/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.firefurnace;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.vector.Vector3d;
import sirttas.elementalcraft.block.instrument.TileInstrument;
import sirttas.elementalcraft.inventory.IOInventory;
import sirttas.elementalcraft.inventory.InventoryTileWrapper;
import sirttas.elementalcraft.recipe.instrument.FurnaceRecipeWrapper;
import sirttas.elementalcraft.recipe.instrument.IInstrumentRecipe;

public abstract class AbstractTileFireFurnace<T extends AbstractCookingRecipe>
extends TileInstrument {
    private float exp = 0.0f;
    private IRecipeType<T> recipeType;
    private final IOInventory inventory;

    protected AbstractTileFireFurnace(TileEntityType<? extends AbstractTileFireFurnace<T>> tileEntityTypeIn, IRecipeType<T> recipeType) {
        this(tileEntityTypeIn);
        this.recipeType = recipeType;
    }

    public AbstractTileFireFurnace(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.outputSlot = 1;
        this.inventory = new IOInventory(this::forceSync);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.exp = compound.func_74760_g("experience");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74776_a("experience", this.exp);
        return compound;
    }

    protected IInstrumentRecipe<AbstractTileFireFurnace<T>> lookupRecipe() {
        return this.func_145831_w().func_199532_z().func_215371_a(this.recipeType, InventoryTileWrapper.from(this), this.func_145831_w()).map(FurnaceRecipeWrapper::new).orElse(null);
    }

    public void dropExperience(PlayerEntity player) {
        this.dropExperience(player.func_213303_ch());
    }

    public void dropExperience(Vector3d pos) {
        while (this.exp > 0.0f) {
            int j = ExperienceOrbEntity.func_70527_a((int)((int)this.exp));
            this.exp -= (float)j;
            this.field_145850_b.func_217376_c((Entity)new ExperienceOrbEntity(this.field_145850_b, pos.func_82615_a(), pos.func_82617_b() + 0.5, pos.func_82616_c() + 0.5, j));
        }
        this.exp = 0.0f;
    }

    public void addExperience(float exp) {
        this.exp += exp;
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }
}

