/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.block.pureinfuser.BlockPedestal;
import sirttas.elementalcraft.block.pureinfuser.TilePureInfuser;
import sirttas.elementalcraft.block.tile.TileECContainer;
import sirttas.elementalcraft.block.tile.element.IElementReceiver;
import sirttas.elementalcraft.inventory.SingleItemInventory;

public class TilePedestal
extends TileECContainer
implements IElementReceiver {
    @ObjectHolder(value="elementalcraft:pedestal")
    public static TileEntityType<TilePedestal> TYPE;
    private int elementAmount = 0;
    protected int elementMax = 10000;
    private final SingleItemInventory inventory = new SingleItemInventory(this::forceSync);

    public TilePedestal() {
        super(TYPE);
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public int getMaxElement() {
        return this.elementMax;
    }

    @Override
    public ElementType getElementType() {
        return ((BlockPedestal)this.func_195044_w().func_177230_c()).getElementType();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.elementAmount = compound.func_74762_e("element_amount");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("element_amount", this.elementAmount);
        return compound;
    }

    @Override
    public int inserElement(int count, ElementType type, boolean simulate) {
        if (type != this.getElementType()) {
            return 0;
        }
        int newCount = Math.min(this.elementAmount + count, this.elementMax);
        int ret = count - newCount + this.elementAmount;
        if (!simulate) {
            this.elementAmount = newCount;
        }
        return ret;
    }

    public int consumeElement(int i) {
        int newCount = Math.max(this.elementAmount - i, 0);
        int ret = this.elementAmount - newCount;
        this.elementAmount = newCount;
        this.forceSync();
        return ret;
    }

    private Optional<TilePureInfuser> getPureInfuser() {
        return Stream.of(Direction.values()).filter(d -> d.func_176740_k().func_176716_d() == Direction.Plane.HORIZONTAL).map(d -> this.func_145831_w().func_175625_s(this.field_174879_c.func_177967_a(d, 3))).filter(TilePureInfuser.class::isInstance).map(TilePureInfuser.class::cast).findAny();
    }

    public boolean isPureInfuserRunning() {
        Optional<TilePureInfuser> opt = this.getPureInfuser();
        return opt.isPresent() && opt.get().isRunning();
    }

    public Direction getPureInfuserDirection() {
        return Stream.of(Direction.values()).filter(d -> d.func_176740_k().func_176716_d() == Direction.Plane.HORIZONTAL).filter(d -> this.func_145831_w().func_175625_s(this.field_174879_c.func_177967_a(d, 3)) instanceof TilePureInfuser).findAny().orElse(Direction.UP);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    public ItemStack getItem() {
        return this.inventory.func_70301_a(0);
    }
}

