/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.ore;

import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.block.shrine.TileShrine;
import sirttas.elementalcraft.config.ECConfig;

public class TileOreShrine
extends TileShrine {
    @ObjectHolder(value="elementalcraft:oreshrine")
    public static TileEntityType<TileOreShrine> TYPE;

    public TileOreShrine() {
        super(TYPE, ElementType.EARTH, (Double)ECConfig.CONFIG.oreShrinePeriode.get());
        this.elementMax *= 10;
    }

    private Optional<BlockPos> findOre() {
        int range = (Integer)ECConfig.CONFIG.oreShrineRange.get();
        return IntStream.range(-range, range + 1).mapToObj(x -> IntStream.range(-range, range + 1).mapToObj(z -> IntStream.range(0, this.field_174879_c.func_177956_o() + 1).mapToObj(y -> new BlockPos(this.field_174879_c.func_177958_n() + x, y, this.field_174879_c.func_177952_p() + z)))).flatMap(s -> s.flatMap(s2 -> s2)).filter(p -> Tags.Blocks.ORES.func_230235_a_((Object)this.field_145850_b.func_180495_p(p).func_177230_c())).findAny();
    }

    @Override
    protected void doTick() {
        int consumeAmount = (Integer)ECConfig.CONFIG.oreShrineConsumeAmount.get();
        if (this.field_145850_b instanceof ServerWorld && this.getElementAmount() >= consumeAmount) {
            Optional<BlockPos> opt = this.findOre();
            opt.ifPresent(p -> {
                BlockState blockstate = this.field_145850_b.func_180495_p(p);
                blockstate.func_215693_a(new LootContext.Builder((ServerWorld)this.field_145850_b).func_216023_a(this.field_145850_b.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)p)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a)).forEach(s -> Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)s));
                this.field_145850_b.func_175656_a((BlockPos)opt.get(), Blocks.field_150348_b.func_176223_P());
                this.consumeElement(consumeAmount);
            });
        }
    }
}

