/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source;

import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.block.BlockEC;
import sirttas.elementalcraft.item.receptacle.ISourceInteractable;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.property.ECProperties;

public class BlockSource
extends BlockEC {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    public static final String NAME = "source";

    public BlockSource() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151579_a).func_200948_a(-1.0f, 3600000.0f).func_226896_b_().func_222380_e().func_235859_g_());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(ECProperties.ELEMENT_TYPE, (Comparable)((Object)ElementType.NONE)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{ECProperties.ELEMENT_TYPE});
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.showShape(state, context) ? SHAPE : VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    private boolean showShape(BlockState state, ISelectionContext context) {
        return Optional.ofNullable(context.getEntity()).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).filter(e -> Stream.of(e.func_184614_ca(), e.func_184592_cb()).anyMatch(s -> s.func_77973_b() instanceof ISourceInteractable && ((ISourceInteractable)s.func_77973_b()).canIteractWithSource((ItemStack)s, state))).isPresent();
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.func_177229_b(ECProperties.ELEMENT_TYPE) == ElementType.NONE) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a(ECProperties.ELEMENT_TYPE, (Comparable)((Object)ElementType.random())));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        ParticleHelper.createSourceParticle(ElementType.getElementType(state), world, Vector3d.func_237491_b_((Vector3i)pos), rand);
    }
}

