/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.spelldesk;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.block.BlockEC;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;

public class BlockSpellDesk
extends BlockEC {
    public static final String NAME = "spell_desk";
    private static final VoxelShape BASE_1 = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    private static final VoxelShape BASE_2 = Block.func_208617_a((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);
    private static final VoxelShape PILAR = Block.func_208617_a((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0);
    private static final VoxelShape PLATE_WEST_1 = Block.func_208617_a((double)1.0, (double)8.0, (double)2.0, (double)6.0, (double)10.0, (double)14.0);
    private static final VoxelShape PLATE_WEST_2 = Block.func_208617_a((double)4.0, (double)10.0, (double)2.0, (double)11.0, (double)12.0, (double)14.0);
    private static final VoxelShape PLATE_WEST_3 = Block.func_208617_a((double)9.0, (double)12.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0);
    private static final VoxelShape PLATE_EAST_1 = Block.func_208617_a((double)10.0, (double)8.0, (double)2.0, (double)15.0, (double)10.0, (double)14.0);
    private static final VoxelShape PLATE_EAST_2 = Block.func_208617_a((double)5.0, (double)10.0, (double)2.0, (double)12.0, (double)12.0, (double)14.0);
    private static final VoxelShape PLATE_EAST_3 = Block.func_208617_a((double)1.0, (double)12.0, (double)2.0, (double)7.0, (double)14.0, (double)14.0);
    private static final VoxelShape PLATE_NORTH_1 = Block.func_208617_a((double)2.0, (double)8.0, (double)1.0, (double)14.0, (double)10.0, (double)6.0);
    private static final VoxelShape PLATE_NORTH_2 = Block.func_208617_a((double)2.0, (double)10.0, (double)4.0, (double)14.0, (double)12.0, (double)11.0);
    private static final VoxelShape PLATE_NORTH_3 = Block.func_208617_a((double)2.0, (double)12.0, (double)9.0, (double)14.0, (double)14.0, (double)15.0);
    private static final VoxelShape PLATE_SOUTH_1 = Block.func_208617_a((double)2.0, (double)8.0, (double)10.0, (double)14.0, (double)10.0, (double)15.0);
    private static final VoxelShape PLATE_SOUTH_2 = Block.func_208617_a((double)2.0, (double)10.0, (double)5.0, (double)14.0, (double)12.0, (double)12.0);
    private static final VoxelShape PLATE_SOUTH_3 = Block.func_208617_a((double)2.0, (double)12.0, (double)1.0, (double)14.0, (double)14.0, (double)7.0);
    private static final VoxelShape MAIN_SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, PILAR});
    private static final VoxelShape NORTH_SHAPE = VoxelShapes.func_216384_a((VoxelShape)MAIN_SHAPE, (VoxelShape[])new VoxelShape[]{PLATE_NORTH_1, PLATE_NORTH_2, PLATE_NORTH_3});
    private static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_216384_a((VoxelShape)MAIN_SHAPE, (VoxelShape[])new VoxelShape[]{PLATE_SOUTH_1, PLATE_SOUTH_2, PLATE_SOUTH_3});
    private static final VoxelShape WEST_SHAPE = VoxelShapes.func_216384_a((VoxelShape)MAIN_SHAPE, (VoxelShape[])new VoxelShape[]{PLATE_WEST_1, PLATE_WEST_2, PLATE_WEST_3});
    private static final VoxelShape EAST_SHAPE = VoxelShapes.func_216384_a((VoxelShape)MAIN_SHAPE, (VoxelShape[])new VoxelShape[]{PLATE_EAST_1, PLATE_EAST_2, PLATE_EAST_3});
    public static final BooleanProperty HAS_PAPER = BooleanProperty.func_177716_a((String)"has_paper");
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public BlockSpellDesk() {
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)HAS_PAPER, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{FACING, HAS_PAPER});
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return MAIN_SHAPE;
    }

    private boolean hasPaper(BlockState state) {
        return Boolean.TRUE.equals(state.func_177229_b((Property)HAS_PAPER));
    }

    private void createSpell(BlockState state, World world, BlockPos pos, PlayerEntity player, ItemStack stack, ElementType type) {
        Random rand = world.field_73012_v;
        int count = Math.min(10, stack.func_190916_E());
        Vector3d position = Vector3d.func_237491_b_((Vector3i)pos).func_72441_c(0.5, 0.7, 0.5);
        if (rand.nextDouble() < (double)count * 0.06 + 0.2) {
            List spells = Spell.REGISTRY.getValues().stream().filter(s -> s.getElementType() == type && s.getSpellType() != Spell.Type.NONE).collect(Collectors.toList());
            Spell spell = (Spell)((Object)spells.get(rand.nextInt(spells.size())));
            ItemStack scroll = new ItemStack((IItemProvider)ECItems.scroll);
            SpellHelper.setSpell(scroll, spell);
            if (!world.func_201670_d()) {
                world.func_217376_c((Entity)new ItemEntity(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), scroll));
            } else {
                ParticleHelper.createCraftingParticle(type, world, Vector3d.func_237491_b_((Vector3i)pos), rand);
            }
        } else {
            world.func_184134_a(position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 0.8f, 0.8f + rand.nextFloat() * 0.4f, false);
            ParticleHelper.createItemBreakParticle(world, position, rand, new ItemStack((IItemProvider)Items.field_151121_aF), count);
        }
        if (!player.func_184812_l_()) {
            stack.func_190918_g(count);
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HAS_PAPER, (Comparable)Boolean.valueOf(false)));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151121_aF && !this.hasPaper(state)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HAS_PAPER, (Comparable)Boolean.valueOf(true)));
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
        } else if (this.hasPaper(state)) {
            if (stack.func_77973_b() == ECItems.fireCrystal) {
                this.createSpell(state, world, pos, player, stack, ElementType.FIRE);
            } else if (stack.func_77973_b() == ECItems.waterCrystal) {
                this.createSpell(state, world, pos, player, stack, ElementType.WATER);
            } else if (stack.func_77973_b() == ECItems.earthCrystal) {
                this.createSpell(state, world, pos, player, stack, ElementType.EARTH);
            } else if (stack.func_77973_b() == ECItems.airCrystal) {
                this.createSpell(state, world, pos, player, stack, ElementType.AIR);
            }
        }
        return ActionResultType.PASS;
    }
}

