/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.tank;

import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.block.tile.TileEC;
import sirttas.elementalcraft.block.tile.element.IElementReceiver;
import sirttas.elementalcraft.block.tile.element.IElementSender;
import sirttas.elementalcraft.config.ECConfig;

public class TileTank
extends TileEC
implements IElementSender,
IElementReceiver {
    @ObjectHolder(value="elementalcraft:tank")
    public static TileEntityType<TileTank> TYPE;
    private int elementAmount = 0;
    private int elementAmountMax = 100000;
    private ElementType elementType = ElementType.NONE;
    private boolean small = false;

    public TileTank(int elementAmountMax) {
        super(TYPE);
        this.elementAmountMax = elementAmountMax;
    }

    public TileTank(boolean small) {
        this(small ? (Integer)ECConfig.CONFIG.tankSmallMaxAmount.get() : (Integer)ECConfig.CONFIG.tankMaxAmount.get());
        this.setSmall(small);
    }

    public TileTank() {
        this(false);
    }

    @Override
    public int inserElement(int count, ElementType type, boolean simulate) {
        if (type != this.elementType && this.elementType != ElementType.NONE) {
            return this.extractElement(count, this.elementType, simulate);
        }
        int newCount = Math.min(this.elementAmount + count, this.elementAmountMax);
        int ret = count - newCount + this.elementAmount;
        if (!simulate) {
            this.elementAmount = newCount;
            if (this.elementType == ElementType.NONE) {
                this.elementType = type;
            }
        }
        return ret;
    }

    @Override
    public int extractElement(int count, ElementType type, boolean simulate) {
        if (type != this.elementType) {
            return 0;
        }
        int newCount = Math.max(this.elementAmount - count, 0);
        int ret = this.elementAmount - newCount;
        if (!simulate) {
            this.elementAmount = newCount;
            if (this.elementAmount == 0) {
                this.elementType = ElementType.NONE;
            }
        }
        return ret;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public int getMaxElement() {
        return this.elementAmountMax;
    }

    public boolean isSmall() {
        return this.small;
    }

    public void setSmall(boolean small) {
        this.small = small;
    }

    @Override
    public boolean doesRenderGauge() {
        return true;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.elementType = ElementType.byName(compound.func_74779_i("element_type"));
        this.elementAmount = compound.func_74762_e("element_amount");
        this.elementAmountMax = compound.func_74762_e("element_max");
        this.small = compound.func_74767_n("small");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("element_type", this.elementType.func_176610_l());
        compound.func_74768_a("element_amount", this.elementAmount);
        compound.func_74768_a("element_max", this.elementAmountMax);
        compound.func_74757_a("small", this.small);
        return compound;
    }
}

