/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ECConfig {
    public static final ECConfig CONFIG;
    public static final ForgeConfigSpec SPEC;
    public final ForgeConfigSpec.DoubleValue swordAirInfusionSpeedBonus;
    public final ForgeConfigSpec.DoubleValue leggingsAirInfusionSpeedBonus;
    public final ForgeConfigSpec.IntValue shrineMaxAmount;
    public final ForgeConfigSpec.IntValue firePylonRange;
    public final ForgeConfigSpec.IntValue firePylonConsumeAmount;
    public final ForgeConfigSpec.IntValue vacuumShrineRange;
    public final ForgeConfigSpec.IntValue vacuumShrineConsumeAmount;
    public final ForgeConfigSpec.DoubleValue vacuumShrinePullSpeed;
    public final ForgeConfigSpec.IntValue growthShrineRange;
    public final ForgeConfigSpec.IntValue growthShrineConsumeAmount;
    public final ForgeConfigSpec.DoubleValue growthShrineChance;
    public final ForgeConfigSpec.DoubleValue growthShrinePeriode;
    public final ForgeConfigSpec.IntValue harvestShrineRange;
    public final ForgeConfigSpec.IntValue harvestShrineConsumeAmount;
    public final ForgeConfigSpec.DoubleValue harvestShrineChance;
    public final ForgeConfigSpec.DoubleValue harvestShrinePeriode;
    public final ForgeConfigSpec.IntValue lavaShrineRange;
    public final ForgeConfigSpec.IntValue lavaShrineConsumeAmount;
    public final ForgeConfigSpec.DoubleValue lavaShrineChance;
    public final ForgeConfigSpec.DoubleValue lavaShrinePeriode;
    public final ForgeConfigSpec.IntValue oreShrineRange;
    public final ForgeConfigSpec.IntValue oreShrineConsumeAmount;
    public final ForgeConfigSpec.DoubleValue oreShrinePeriode;
    public final ForgeConfigSpec.IntValue overloadShrineConsumeAmount;
    public final ForgeConfigSpec.DoubleValue overloadShrinePeriode;
    public final ForgeConfigSpec.IntValue sweetShrineRange;
    public final ForgeConfigSpec.IntValue sweetShrineConsumeAmount;
    public final ForgeConfigSpec.DoubleValue sweetShrinePeriode;
    public final ForgeConfigSpec.IntValue enderLockShrineRange;
    public final ForgeConfigSpec.IntValue enderLockShrineConsumeAmount;
    public final ForgeConfigSpec.IntValue tankMaxAmount;
    public final ForgeConfigSpec.IntValue tankSmallMaxAmount;
    public final ForgeConfigSpec.IntValue extractorExtractionAmount;
    public final ForgeConfigSpec.IntValue improvedExtractorExtractionAmount;
    public final ForgeConfigSpec.IntValue fireFurnaceConsumeAmount;
    public final ForgeConfigSpec.IntValue fireBlastFurnaceConsumeAmount;
    public final ForgeConfigSpec.IntValue purifierConsumeAmount;
    public final ForgeConfigSpec.IntValue purifierDuration;
    public final ForgeConfigSpec.IntValue impairedPipeTransferAmount;
    public final ForgeConfigSpec.IntValue pipeTransferAmount;
    public final ForgeConfigSpec.IntValue improvedPipeTransferAmount;
    public final ForgeConfigSpec.BooleanValue pureOreSmeltingRecipeInjection;
    public final ForgeConfigSpec.BooleanValue binderRecipeMatchOrder;
    public final ForgeConfigSpec.IntValue receptacleDurability;
    public final ForgeConfigSpec.IntValue elementHolderMaxAmount;
    public final ForgeConfigSpec.IntValue elementHolderTransferAmount;
    public final ForgeConfigSpec.IntValue focusMaxSpell;
    public final ForgeConfigSpec.BooleanValue disableWorldGen;
    public final ForgeConfigSpec.IntValue sourceSpawnChance;
    public final ForgeConfigSpec.IntValue sourceAltarDistance;
    public final ForgeConfigSpec.IntValue enderStrikeConsumeAmount;
    public final ForgeConfigSpec.IntValue enderStrikeCooldown;
    public final ForgeConfigSpec.DoubleValue enderStrikeRange;
    public final ForgeConfigSpec.IntValue itemPullConsumeAmount;
    public final ForgeConfigSpec.IntValue itemPullCooldown;
    public final ForgeConfigSpec.DoubleValue itemPullRange;
    public final ForgeConfigSpec.IntValue gravelFallConsumeAmount;
    public final ForgeConfigSpec.IntValue gravelFallCooldown;
    public final ForgeConfigSpec.IntValue stoneWallConsumeAmount;
    public final ForgeConfigSpec.IntValue stoneWallCooldown;
    public final ForgeConfigSpec.IntValue fireBallConsumeAmount;
    public final ForgeConfigSpec.IntValue fireBallCooldown;
    public final ForgeConfigSpec.IntValue animalGrowthConsumeAmount;
    public final ForgeConfigSpec.IntValue animalGrowthCooldown;
    public final ForgeConfigSpec.IntValue treeFallConsumeAmount;
    public final ForgeConfigSpec.IntValue treeFallCooldown;
    public final ForgeConfigSpec.IntValue purificationConsumeAmount;
    public final ForgeConfigSpec.IntValue purificationCooldown;
    public final ForgeConfigSpec.IntValue ripeningConsumeAmount;
    public final ForgeConfigSpec.IntValue ripeningCooldown;
    public final ForgeConfigSpec.IntValue flameCleaveConsumeAmount;
    public final ForgeConfigSpec.IntValue flameCleaveCooldown;
    public final ForgeConfigSpec.DoubleValue flameCleaveRange;
    public final ForgeConfigSpec.IntValue infernoConsumeAmount;
    public final ForgeConfigSpec.IntValue infernoCooldown;
    public final ForgeConfigSpec.DoubleValue infernoRange;
    public final ForgeConfigSpec.IntValue dashConsumeAmount;
    public final ForgeConfigSpec.IntValue dashCooldown;
    public final ForgeConfigSpec.DoubleValue dashRange;
    public final ForgeConfigSpec.IntValue healConsumeAmount;
    public final ForgeConfigSpec.IntValue healCooldown;

    public ECConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("ElementalCraft config").push("elementalcraft");
        builder.push("infusion");
        this.swordAirInfusionSpeedBonus = builder.comment("The bonus to sword attack speed provided by the air infusion.").defineInRange("swordAirInfusionSpeedBonus", 0.8, 0.0, 10.0);
        this.leggingsAirInfusionSpeedBonus = builder.comment("The bonus to movement speed provided by the air infusion.").defineInRange("leggingsAirInfusionSpeedBonus", 0.01, 0.0, 1.0);
        builder.pop().comment("Shrines config").push("shrines");
        this.shrineMaxAmount = builder.comment("The max element amount a shrine can hold.").defineInRange("shrineMaxAmount", 10000, 0, 100000000);
        builder.push("firePylon");
        this.firePylonRange = builder.comment("The range of the Fire Pylon.").defineInRange("firePylonRange", 10, 0, 100);
        this.firePylonConsumeAmount = builder.comment("The amount of element consumed by the Fire Pylon.").defineInRange("firePylonConsumeAmount", 5, 0, 100);
        builder.pop().push("vacuumShrine");
        this.vacuumShrineRange = builder.comment("The range of the Vacuum Shrine.").defineInRange("vacuumShrineRange", 10, 0, 100);
        this.vacuumShrineConsumeAmount = builder.comment("The amount of element consumed by the Vacuum Shrine.").defineInRange("vacuumShrineConsumeAmount", 1, 0, 100);
        this.vacuumShrinePullSpeed = builder.comment("The pull speed of the Vacuum Shrine.").defineInRange("vacuumShrinePullSpeed", 0.1, 0.0, 5.0);
        builder.pop().push("growthShrine");
        this.growthShrineRange = builder.comment("The range of the Growth Shrine.").defineInRange("growthShrineRange", 4, 0, 100);
        this.growthShrineConsumeAmount = builder.comment("The amount of element consumed by the Growth Shrine.").defineInRange("growthShrineConsumeAmount", 50, 0, 1000);
        this.growthShrineChance = builder.comment("The chance of the Growth Shrine to tick.").defineInRange("growthShrineChance", 0.02, 0.0, 1.0);
        this.growthShrinePeriode = builder.comment("The nember of tick betwenn two GFrowth Shrine activations.").defineInRange("growthShrinePeriode", 20.0, 0.0, 2400.0);
        builder.pop().push("harvestShrine");
        this.harvestShrineRange = builder.comment("The range of the Harvest Shrine.").defineInRange("harvestShrineRange", 4, 0, 100);
        this.harvestShrineConsumeAmount = builder.comment("The amount of element consumed by the Harvest Shrine.").defineInRange("harvestShrineConsumeAmount", 100, 0, 1000);
        this.harvestShrineChance = builder.comment("The chance of the Harvest Shrine to tick.").defineInRange("harvestShrineChance", 0.02, 0.0, 1.0);
        this.harvestShrinePeriode = builder.comment("The nember of tick betwenn two Harvest Shrine activations.").defineInRange("harvestShrinePeriode", 20.0, 0.0, 2400.0);
        builder.pop().push("lavaShrine");
        this.lavaShrineRange = builder.comment("The range of the Lava Shrine.").defineInRange("lavaShrineRange", 1, 0, 100);
        this.lavaShrineConsumeAmount = builder.comment("The amount of element consumed by the Lava Shrine.").defineInRange("lavaShrineConsumeAmount", 5000, 0, 100000);
        this.lavaShrineChance = builder.comment("The chance of the Lava Shrine to tick.").defineInRange("lavaShrineChance", 0.02, 0.0, 1.0);
        this.lavaShrinePeriode = builder.comment("The nember of tick betwenn two Lava Shrine activations.").defineInRange("lavaShrinePeriode", 20.0, 0.0, 2400.0);
        builder.pop().push("oreShrine");
        this.oreShrineRange = builder.comment("The range of the Ore Shrine.").defineInRange("oreShrineRange", 6, 0, 100);
        this.oreShrineConsumeAmount = builder.comment("The amount of element consumed by the Ore Shrine.").defineInRange("oreShrineConsumeAmount", 2000, 0, 10000);
        this.oreShrinePeriode = builder.comment("The nember of tick betwenn two Ore Shrine activations.").defineInRange("oreShrinePeriode", 200.0, 0.0, 2400.0);
        builder.pop().push("overloadShrine");
        this.overloadShrineConsumeAmount = builder.comment("The amount of element consumed by the overload Shrine.").defineInRange("overloadShrineConsumeAmount", 100, 0, 1000);
        this.overloadShrinePeriode = builder.comment("The nember of tick betwenn two Overload Shrine activations.").defineInRange("overloadShrinePeriode", 3.0, 0.0, 2400.0);
        builder.pop().push("sweetShrine");
        this.sweetShrineRange = builder.comment("The range of the Sweet Shrine.").defineInRange("sweetShrineRange", 10, 0, 100);
        this.sweetShrineConsumeAmount = builder.comment("The amount of element consumed by the Sweet Shrine.").defineInRange("sweetShrineConsumeAmount", 500, 0, 10000);
        this.sweetShrinePeriode = builder.comment("The nember of tick betwenn two Sweet Shrine activations.").defineInRange("sweetShrinePeriode", 40.0, 0.0, 2400.0);
        builder.pop().push("enderLock");
        this.enderLockShrineRange = builder.comment("The range of the Ender Lock Shrine.").defineInRange("enderLockShrineRange", 10, 0, 100);
        this.enderLockShrineConsumeAmount = builder.comment("The amount of element consumed by the Ender Lock Shrine.").defineInRange("enderLockShrineConsumeAmount", 500, 0, 10000);
        builder.pop(2).comment("Instruments config").push("instruments").push("tank");
        this.tankSmallMaxAmount = builder.comment("The max element amount a small element container can hold.").defineInRange("tankSmallMaxAmount", 1000, 0, 100000000);
        this.tankMaxAmount = builder.comment("The max element amount an element container can hold.").defineInRange("tankMaxAmount", 100000, 0, 100000000);
        builder.pop().push("extractor");
        this.extractorExtractionAmount = builder.comment("The amount of element extracted by an extractor.").defineInRange("extractorExtractionAmount", 5, 0, 100);
        this.improvedExtractorExtractionAmount = builder.comment("The amount of element extracted by an improved extractor.").defineInRange("improvedExtractorExtractionAmount", 25, 0, 500);
        builder.pop().push("fireFurnace");
        this.fireFurnaceConsumeAmount = builder.comment("The amount of element consumed by the Fire Furnace per tick.").defineInRange("fireFurnaceConsumeAmount", 10, 0, 500);
        this.fireBlastFurnaceConsumeAmount = builder.comment("The amount of element consumed by the Fire Blast Furnace per tick.").defineInRange("fireBlastFurnaceConsumeAmount", 20, 0, 500);
        builder.pop().push("purifier");
        this.purifierConsumeAmount = builder.comment("The amount of element consumed by the Ore Purifier per tick.").defineInRange("purifierConsumeAmount", 25, 0, 1000);
        this.purifierDuration = builder.comment("The nember of tick for a Ore Purifier co procces one item.").defineInRange("purifierDuration", 100, 0, 2400);
        builder.pop().push("elementPipe");
        this.impairedPipeTransferAmount = builder.comment("The amount of element transferred by impaired pipes.").defineInRange("impairedPipeTransferAmount", 5, 0, 10000);
        this.pipeTransferAmount = builder.comment("The amount of element transferred by pipes.").defineInRange("pipeTransferAmount", 25, 0, 10000);
        this.improvedPipeTransferAmount = builder.comment("The amount of element transferred by improved pipes.").defineInRange("improvedPipeTransferAmount", 100, 0, 10000);
        builder.pop();
        this.pureOreSmeltingRecipeInjection = builder.comment("Set to false if you want to manualy manage processing of pure ore.").define("pureOreSmeltingRecipeInjection", true);
        this.binderRecipeMatchOrder = builder.comment("Define if or not binder recip require to be ordered.").define("binderRecipeMatchOrder", true);
        builder.pop().comment("Items config").push("items");
        this.receptacleDurability = builder.comment("Define source receptacle durablility (0 for unbreakable).").defineInRange("receptacleDurability", 20, 0, 1000);
        this.elementHolderMaxAmount = builder.comment("The max element amount an element holder can hold.").defineInRange("elementHolderMaxAmount", 10000, 0, 100000000);
        this.elementHolderTransferAmount = builder.comment("The amount of element transfered by an element holder.").defineInRange("elementHolderTransferAmount", 25, 0, 1000);
        this.focusMaxSpell = builder.comment("The max number of spells on a focus.").defineInRange("focusMaxSpell", 10, 1, 20);
        builder.pop().comment("Worldgen config").push("worldgen");
        this.disableWorldGen = builder.comment("Disable all elementalcraft world gen.").define("disableWorldGen", false);
        this.sourceSpawnChance = builder.comment("Chance to add a source in world (the small the more frequante).").defineInRange("sourceSpawnChance", 20, 1, 10000);
        this.sourceAltarDistance = builder.comment("CSource Altar genreration distance setting.").defineInRange("sourceAltarDistance", 16, 0, 100);
        builder.pop().comment("Spells config").push("spells").push("enderStrike");
        this.enderStrikeConsumeAmount = builder.comment("The amount of element consumed by the ender strike.").defineInRange("enderStrikeConsumeAmount", 1000, 0, 10000);
        this.enderStrikeCooldown = builder.comment("The cooldown the ender strike.").defineInRange("enderStrikeCooldown", 60, 0, 10000);
        this.enderStrikeRange = builder.comment("The range the ender strike.").defineInRange("enderStrikeRange", 20.0, 0.0, 200.0);
        builder.pop().push("itemPull");
        this.itemPullConsumeAmount = builder.comment("The amount of element consumed by the item pull.").defineInRange("itemPullConsumeAmount", 1000, 0, 10000);
        this.itemPullCooldown = builder.comment("The cooldown the item pull.").defineInRange("itemPullCooldown", 200, 0, 10000);
        this.itemPullRange = builder.comment("The range the item pull.").defineInRange("itemPullRange", 10.0, 0.0, 200.0);
        builder.pop().push("gravelFall");
        this.gravelFallConsumeAmount = builder.comment("The amount of element consumed by the gravel fall.").defineInRange("gravelFallConsumeAmount", 250, 0, 10000);
        this.gravelFallCooldown = builder.comment("The cooldown the gravel fall.").defineInRange("gravelFallCooldown", 40, 0, 10000);
        builder.pop().push("stoneWall");
        this.stoneWallConsumeAmount = builder.comment("The amount of element consumed by the stone wall.").defineInRange("stoneWallConsumeAmount", 500, 0, 10000);
        this.stoneWallCooldown = builder.comment("The cooldown the stone wall.").defineInRange("stoneWallCooldown", 100, 0, 10000);
        builder.pop().push("fireBall");
        this.fireBallConsumeAmount = builder.comment("The amount of element consumed by the fire ball.").defineInRange("fireBallConsumeAmount", 500, 0, 10000);
        this.fireBallCooldown = builder.comment("The cooldown the fire ball.").defineInRange("fireBallCooldown", 100, 0, 10000);
        builder.pop().push("animalGrowth");
        this.animalGrowthConsumeAmount = builder.comment("The amount of element consumed by the animal growth.").defineInRange("animalGrowthConsumeAmount", 2000, 0, 10000);
        this.animalGrowthCooldown = builder.comment("The cooldown the animal growth.").defineInRange("animalGrowthCooldown", 200, 0, 10000);
        builder.pop().push("treeFall");
        this.treeFallConsumeAmount = builder.comment("The amount of element consumed by the tree fall.").defineInRange("treeFallConsumeAmount", 3000, 0, 10000);
        this.treeFallCooldown = builder.comment("The cooldown the tree fall.").defineInRange("treeFallCooldown", 600, 0, 10000);
        builder.pop().push("purification");
        this.purificationConsumeAmount = builder.comment("The amount of element consumed by the purification.").defineInRange("purificationConsumeAmount", 1000, 0, 10000);
        this.purificationCooldown = builder.comment("The cooldown the purification.").defineInRange("purificationCooldown", 200, 0, 10000);
        builder.pop().push("ripening");
        this.ripeningConsumeAmount = builder.comment("The amount of element consumed by the ripening.").defineInRange("ripeningConsumeAmount", 200, 0, 10000);
        this.ripeningCooldown = builder.comment("The cooldown the ripening.").defineInRange("ripeningCooldown", 20, 0, 10000);
        builder.pop().push("flameCleave");
        this.flameCleaveConsumeAmount = builder.comment("The amount of element consumed by the flame Cleave.").defineInRange("flameCleaveConsumeAmount", 1000, 0, 10000);
        this.flameCleaveCooldown = builder.comment("The cooldown the flame Cleave.").defineInRange("flameCleaveCooldown", 60, 0, 10000);
        this.flameCleaveRange = builder.comment("The range the flame Cleave.").defineInRange("flameCleaveRange", 3.0, 0.0, 20.0);
        builder.pop().push("inferno");
        this.infernoConsumeAmount = builder.comment("The amount of element consumed by the inferno.").defineInRange("infernoConsumeAmount", 10, 0, 10000);
        this.infernoCooldown = builder.comment("The cooldown the inferno.").defineInRange("infernoCooldown", 120, 0, 10000);
        this.infernoRange = builder.comment("The range the inferno.").defineInRange("infernoRange", 5.0, 0.0, 20.0);
        builder.pop().push("dash");
        this.dashConsumeAmount = builder.comment("The amount of element consumed by the dash.").defineInRange("dashConsumeAmount", 400, 0, 10000);
        this.dashCooldown = builder.comment("The cooldown the dash.").defineInRange("dashCooldown", 40, 0, 10000);
        this.dashRange = builder.comment("The range the dash.").defineInRange("dashRange", 6.0, 0.0, 200.0);
        builder.pop().push("heal");
        this.healConsumeAmount = builder.comment("The amount of element consumed by the heal.").defineInRange("healConsumeAmount", 1000, 0, 10000);
        this.healCooldown = builder.comment("The cooldown the heal.").defineInRange("healCooldown", 600, 0, 10000);
        builder.pop(2);
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ECConfig::new);
        SPEC = (ForgeConfigSpec)pair.getRight();
        CONFIG = (ECConfig)pair.getLeft();
    }
}

