/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.ElementalCraft;

public class GuiHelper {
    private static final ResourceLocation GAUGE = ElementalCraft.createRL("textures/gui/element_gauge.png");

    public static void blit(MatrixStack matrixStack, int x, int y, int u, int v, int width, int height) {
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)256, (int)256);
    }

    private static int getElementTypeOffset(ElementType type) {
        switch (type) {
            case WATER: {
                return 1;
            }
            case FIRE: {
                return 2;
            }
            case EARTH: {
                return 3;
            }
            case AIR: {
                return 4;
            }
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderElementGauge(MatrixStack matrixStack, int x, int y, int amount, int max, ElementType type) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(GAUGE);
        GuiHelper.blit(matrixStack, x, y, 0, 0, 17, 17);
        int progress = Math.max(0, (int)((double)amount / (double)max * 17.0));
        if (progress <= 1 && amount > 0) {
            progress = 2;
        }
        GuiHelper.blit(matrixStack, x, y + 17 - progress, GuiHelper.getElementTypeOffset(type) * 17, 17 - progress, 17, progress);
        if (GuiHelper.showDebugInfo()) {
            mc.field_71466_p.func_238405_a_(matrixStack, amount + "/" + max, (float)x, (float)(y + 17), 0xFFFFFF);
        }
    }

    public static boolean showDebugInfo() {
        Minecraft minecraft = Minecraft.func_71410_x();
        return minecraft.field_71439_g.func_184812_l_() && minecraft.field_71474_y.field_82882_x;
    }
}

