/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.infusion;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.ObjIntConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.nbt.NBTHelper;
import sirttas.elementalcraft.recipe.instrument.infusion.ToolInfusionRecipe;
import sirttas.elementalcraft.tag.ECTags;

public class InfusionHelper {
    private static final UUID INFUSION_MODIFIER = UUID.fromString("908183f3-2486-41db-b92b-e2b16156bc07");
    private static Map<ElementType, Map<ItemClass, ObjIntConsumer<ItemStack>>> infusionMap = new EnumMap<ElementType, Map<ItemClass, ObjIntConsumer<ItemStack>>>(ElementType.class);

    private static void addInfusionToMap(ItemClass itemClass, ElementType type, ObjIntConsumer<ItemStack> consumer) {
        infusionMap.get((Object)type).put(itemClass, consumer);
    }

    public static void addEnchantmentLevel(ItemStack stack, int levelToAdd, Enchantment enchantment) {
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        Integer froLvl = (Integer)map.get(enchantment);
        int level = (froLvl != null ? froLvl : 0) + levelToAdd;
        if (level > 0) {
            map.put(enchantment, level);
        } else {
            map.remove(enchantment);
        }
        EnchantmentHelper.func_82782_a((Map)map, (ItemStack)stack);
    }

    public static List<ToolInfusionRecipe> getRecipes() {
        return Stream.of(ElementType.values()).filter(e -> e != ElementType.NONE).flatMap(e -> Stream.of(ItemClass.values()).flatMap(c -> c.tag.func_230236_b_().stream().map(i -> new DisplayToolInfusionRecipe((Item)i, (ElementType)((Object)e))))).collect(Collectors.toList());
    }

    private static void addAttributeModifier(ItemStack stack, Attribute attribute, double amount, EquipmentSlotType slot) {
        stack.func_185129_a(attribute, new AttributeModifier(INFUSION_MODIFIER, "Infusion modifier", amount, AttributeModifier.Operation.ADDITION), slot);
    }

    private static void applyAttributeModifierInfusion(ItemStack stack, EquipmentSlotType slot, Attribute attribute, double amount) {
        stack.func_111283_C(slot).forEach((k, v) -> {
            if (k.equals(attribute)) {
                InfusionHelper.addAttributeModifier(stack, attribute, v.func_111164_d() + amount, slot);
            } else {
                stack.func_185129_a(k, v, slot);
            }
        });
        if (!stack.func_111283_C(slot).containsKey((Object)attribute)) {
            InfusionHelper.addAttributeModifier(stack, attribute, amount, slot);
        }
    }

    private static void applyInfusion(ItemStack stack, int mult) {
        ObjIntConsumer<ItemStack> consumer;
        ElementType type = InfusionHelper.getInfusion(stack);
        Optional<ItemClass> opt = InfusionHelper.getItemClass(stack);
        if (type != ElementType.NONE && opt.isPresent() && (consumer = infusionMap.get((Object)type).get((Object)opt.get())) != null) {
            consumer.accept(stack, mult);
        }
    }

    public static void unapplyInfusion(ItemStack stack) {
        CompoundNBT nbt = InfusionHelper.getInfusionTag(stack);
        if (nbt != null && InfusionHelper.isApplied(stack)) {
            InfusionHelper.applyInfusion(stack, -1);
            nbt.func_74757_a("applied", false);
        }
    }

    public static void applyInfusion(ItemStack stack) {
        CompoundNBT nbt = InfusionHelper.getInfusionTag(stack);
        if (nbt != null && InfusionHelper.hasInfusion(stack) && !InfusionHelper.isApplied(stack)) {
            InfusionHelper.applyInfusion(stack, 1);
            nbt.func_74757_a("applied", true);
        }
    }

    public static ElementType getInfusion(ItemStack stack) {
        CompoundNBT nbt = InfusionHelper.getInfusionTag(stack);
        if (!stack.func_190926_b() && nbt != null && nbt.func_74764_b("type")) {
            return ElementType.byName(nbt.func_74779_i("type"));
        }
        return ElementType.NONE;
    }

    public static boolean hasInfusion(ItemStack stack) {
        return !InfusionHelper.hasInfusion(stack, ElementType.NONE);
    }

    public static boolean hasInfusion(ItemStack stack, ElementType type) {
        return InfusionHelper.getInfusion(stack) == type;
    }

    public static boolean hasInfusion(LivingEntity entity, EquipmentSlotType slot, ElementType type) {
        return InfusionHelper.hasInfusion(entity.func_184582_a(slot), type);
    }

    public static void setInfusion(ItemStack stack, ElementType type) {
        CompoundNBT nbt = InfusionHelper.getOrCreateInfusionTag(stack);
        if (!stack.func_190926_b()) {
            InfusionHelper.unapplyInfusion(stack);
            nbt.func_74778_a("type", type.func_176610_l());
            InfusionHelper.applyInfusion(stack);
        }
    }

    public static void removeInfusion(ItemStack stack) {
        CompoundNBT nbt = InfusionHelper.getInfusionTag(stack);
        if (!stack.func_190926_b() && nbt != null) {
            InfusionHelper.unapplyInfusion(stack);
            NBTHelper.getECTag(stack).func_82580_o("infusion");
        }
    }

    public static boolean canAirInfusionFly(PlayerEntity player) {
        return InfusionHelper.hasInfusion(player.func_184582_a(EquipmentSlotType.CHEST), ElementType.AIR) && !player.func_233570_aj_() && !player.field_71075_bZ.field_75100_b && !player.func_184218_aH();
    }

    public static boolean hasFireInfusionAutoSmelt(ItemStack stack) {
        return InfusionHelper.hasInfusion(stack, ElementType.FIRE) && InfusionHelper.hasClass(stack, ItemClass.PICKAXE);
    }

    public static boolean hasAirInfusionFasterDraw(ItemStack stack) {
        return InfusionHelper.hasInfusion(stack, ElementType.AIR) && InfusionHelper.hasClass(stack, ItemClass.BOW);
    }

    private static boolean hasClass(ItemStack stack, ItemClass itemClass) {
        Optional<ItemClass> opt = InfusionHelper.getItemClass(stack);
        return opt.isPresent() && opt.get() == itemClass;
    }

    public static boolean isInfusable(ItemStack stack) {
        return InfusionHelper.getItemClass(stack).isPresent();
    }

    private static Optional<ItemClass> getItemClass(ItemStack stack) {
        return Stream.of(ItemClass.values()).filter(c -> c.tag.func_230235_a_((Object)stack.func_77973_b())).findFirst();
    }

    private static CompoundNBT getInfusionTag(ItemStack stack) {
        CompoundNBT nbt = NBTHelper.getECTag(stack);
        if (nbt == null || !nbt.func_74764_b("infusion")) {
            return null;
        }
        return nbt.func_74775_l("infusion");
    }

    private static CompoundNBT getOrCreateInfusionTag(ItemStack stack) {
        CompoundNBT nbt = NBTHelper.getOrCreateECTag(stack);
        if (!nbt.func_74764_b("infusion")) {
            nbt.func_218657_a("infusion", (INBT)new CompoundNBT());
        }
        return nbt.func_74775_l("infusion");
    }

    public static boolean isApplied(ItemStack stack) {
        CompoundNBT nbt = InfusionHelper.getInfusionTag(stack);
        return nbt != null && InfusionHelper.hasInfusion(stack) && nbt.func_74767_n("applied");
    }

    static {
        infusionMap.put(ElementType.FIRE, new EnumMap(ItemClass.class));
        infusionMap.put(ElementType.WATER, new EnumMap(ItemClass.class));
        infusionMap.put(ElementType.EARTH, new EnumMap(ItemClass.class));
        infusionMap.put(ElementType.AIR, new EnumMap(ItemClass.class));
        InfusionHelper.addInfusionToMap(ItemClass.SWORD, ElementType.WATER, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_185304_p));
        InfusionHelper.addInfusionToMap(ItemClass.SWORD, ElementType.FIRE, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_77334_n));
        InfusionHelper.addInfusionToMap(ItemClass.SWORD, ElementType.EARTH, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_185302_k));
        InfusionHelper.addInfusionToMap(ItemClass.SWORD, ElementType.AIR, (s, m) -> InfusionHelper.applyAttributeModifierInfusion(s, EquipmentSlotType.MAINHAND, Attributes.field_233825_h_, (Double)ECConfig.CONFIG.swordAirInfusionSpeedBonus.get() * (double)m));
        InfusionHelper.addInfusionToMap(ItemClass.PICKAXE, ElementType.WATER, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_185308_t));
        InfusionHelper.addInfusionToMap(ItemClass.PICKAXE, ElementType.EARTH, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_185307_s));
        InfusionHelper.addInfusionToMap(ItemClass.PICKAXE, ElementType.AIR, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_185305_q));
        InfusionHelper.addInfusionToMap(ItemClass.AXE, ElementType.WATER, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_185304_p));
        InfusionHelper.addInfusionToMap(ItemClass.AXE, ElementType.FIRE, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_77334_n));
        InfusionHelper.addInfusionToMap(ItemClass.AXE, ElementType.EARTH, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_185302_k));
        InfusionHelper.addInfusionToMap(ItemClass.AXE, ElementType.AIR, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_185305_q));
        InfusionHelper.addInfusionToMap(ItemClass.BOW, ElementType.WATER, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_185310_v));
        InfusionHelper.addInfusionToMap(ItemClass.BOW, ElementType.FIRE, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_185311_w));
        InfusionHelper.addInfusionToMap(ItemClass.BOW, ElementType.EARTH, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_185309_u));
        InfusionHelper.addInfusionToMap(ItemClass.CROSSBOW, ElementType.WATER, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_222192_G));
        InfusionHelper.addInfusionToMap(ItemClass.CROSSBOW, ElementType.FIRE, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_222194_I));
        InfusionHelper.addInfusionToMap(ItemClass.CROSSBOW, ElementType.EARTH, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_185307_s));
        InfusionHelper.addInfusionToMap(ItemClass.CROSSBOW, ElementType.AIR, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_222193_H));
        InfusionHelper.addInfusionToMap(ItemClass.HELMET, ElementType.WATER, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_185298_f));
        InfusionHelper.addInfusionToMap(ItemClass.HELMET, ElementType.FIRE, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_77329_d));
        InfusionHelper.addInfusionToMap(ItemClass.HELMET, ElementType.EARTH, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_180310_c));
        InfusionHelper.addInfusionToMap(ItemClass.HELMET, ElementType.AIR, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_180308_g));
        InfusionHelper.addInfusionToMap(ItemClass.CHESTPLATE, ElementType.WATER, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_185297_d));
        InfusionHelper.addInfusionToMap(ItemClass.CHESTPLATE, ElementType.FIRE, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_77329_d));
        InfusionHelper.addInfusionToMap(ItemClass.CHESTPLATE, ElementType.EARTH, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_180310_c));
        InfusionHelper.addInfusionToMap(ItemClass.LEGGINGS, ElementType.WATER, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_185297_d));
        InfusionHelper.addInfusionToMap(ItemClass.LEGGINGS, ElementType.FIRE, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_77329_d));
        InfusionHelper.addInfusionToMap(ItemClass.LEGGINGS, ElementType.EARTH, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_180310_c));
        InfusionHelper.addInfusionToMap(ItemClass.LEGGINGS, ElementType.AIR, (s, m) -> InfusionHelper.applyAttributeModifierInfusion(s, EquipmentSlotType.LEGS, Attributes.field_233821_d_, (Double)ECConfig.CONFIG.leggingsAirInfusionSpeedBonus.get() * (double)m));
        InfusionHelper.addInfusionToMap(ItemClass.BOOTS, ElementType.WATER, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_185300_i));
        InfusionHelper.addInfusionToMap(ItemClass.BOOTS, ElementType.FIRE, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_77329_d));
        InfusionHelper.addInfusionToMap(ItemClass.BOOTS, ElementType.EARTH, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_180310_c));
        InfusionHelper.addInfusionToMap(ItemClass.BOOTS, ElementType.AIR, (s, m) -> InfusionHelper.addEnchantmentLevel(s, m, Enchantments.field_180309_e));
    }

    private static class DisplayToolInfusionRecipe
    extends ToolInfusionRecipe {
        Item item;

        private DisplayToolInfusionRecipe(Item item, ElementType elementType) {
            this.item = item;
            this.with(elementType);
            this.id = ElementalCraft.createRL(item.getRegistryName().func_110624_b() + '_' + item.getRegistryName().func_110623_a() + "_tool_infusion_with_" + elementType.func_176610_l());
        }

        public NonNullList<Ingredient> func_192400_c() {
            return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{this.item})});
        }

        @Override
        public ItemStack func_77571_b() {
            ItemStack stack = new ItemStack((IItemProvider)this.item);
            InfusionHelper.setInfusion(stack, this.elementType);
            return stack;
        }
    }

    public static enum ItemClass {
        SWORD(ECTags.Items.INFUSABLE_SWORDS),
        PICKAXE(ECTags.Items.INFUSABLE_PICKAXES),
        AXE(ECTags.Items.INFUSABLE_AXES),
        SHOVEL(ECTags.Items.INFUSABLE_SHOVELS),
        HOE(ECTags.Items.INFUSABLE_HOES),
        SHIELD(ECTags.Items.INFUSABLE_SHILDS),
        BOW(ECTags.Items.INFUSABLE_BOWS),
        CROSSBOW(ECTags.Items.INFUSABLE_CROSSBOWS),
        HELMET(ECTags.Items.INFUSABLE_HELMETS),
        CHESTPLATE(ECTags.Items.INFUSABLE_CHESTPLATES),
        LEGGINGS(ECTags.Items.INFUSABLE_LEGGINGS),
        BOOTS(ECTags.Items.INFUSABLE_BOOTS);

        ITag.INamedTag<Item> tag;

        private ItemClass(ITag.INamedTag<Item> tags) {
            this.tag = tags;
        }
    }
}

