/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import mezz.jei.color.ColorGetter;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.item.IItemEC;
import sirttas.elementalcraft.property.ECProperties;

public class ItemEC
extends Item
implements IItemEC {
    private boolean glint = false;

    public ItemEC() {
        this(ECProperties.Items.DEFAULT_ITEM_PROPERTIES);
    }

    public ItemEC(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || this.glint;
    }

    public ItemEC setEffect(boolean glint) {
        this.glint = glint;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final int lookupColor(ItemStack stack) {
        try {
            List colors = ColorGetter.getColors((ItemStack)stack, (int)2);
            if (colors != null && !colors.isEmpty()) {
                return (Integer)colors.get(0);
            }
        }
        catch (NoClassDefFoundError e) {
            ElementalCraft.LOGGER.warn("JEI not present, can't lookup item colors", (Throwable)e);
        }
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addAttributeMultimapToTooltip(List<ITextComponent> tooltip, Multimap<Attribute, AttributeModifier> multimap, ITextComponent title) {
        if (!multimap.isEmpty()) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add(title);
            for (Map.Entry entry : multimap.entries()) {
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                double d0 = attributemodifier.func_111164_d();
                double d1 = attributemodifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (((Attribute)entry.getKey()).equals(Attributes.field_233820_c_) ? d0 * 10.0 : d0) : d0 * 100.0;
                if (d0 > 0.0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("attribute.modifier.plus." + attributemodifier.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent(((Attribute)entry.getKey()).func_233754_c_())}).func_240699_a_(TextFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                tooltip.add((ITextComponent)new TranslationTextComponent("attribute.modifier.take." + attributemodifier.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent(((Attribute)entry.getKey()).func_233754_c_())}).func_240699_a_(TextFormatting.RED));
            }
        }
    }
}

