/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.pureore;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.item.pureore.PureOreHelper;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft")
public class PureOreHandler {
    private static boolean tagsReceived = false;
    private static boolean recipesReceived = false;
    private static RecipeManager recipeManager = null;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRecipesUpdate(RecipesUpdatedEvent event) {
        recipeManager = event.getRecipeManager();
        if (tagsReceived) {
            PureOreHandler.process();
        } else {
            ElementalCraft.LOGGER.info("Pure ore generation: Recipes received, waiting for Tags...");
            recipesReceived = true;
        }
    }

    @SubscribeEvent
    public static void onTagsUpdate(TagsUpdatedEvent event) {
        if (recipesReceived) {
            PureOreHandler.process();
        } else {
            ElementalCraft.LOGGER.info("Pure ore generation: Tags received, waiting for Recipes...");
            tagsReceived = true;
        }
    }

    private static void process() {
        PureOreHelper.generatePureOres(recipeManager);
        if (recipesReceived) {
            ElementalCraft.LOGGER.info("JEI loaded before pure ore generation, atempting to reload JEI");
            IResourceManager manager = Minecraft.func_71410_x().func_195551_G();
            Optional.ofNullable(manager).filter(SimpleReloadableResourceManager.class::isInstance).map(SimpleReloadableResourceManager.class::cast).map(r -> r.field_199015_d.stream()).orElse(Stream.empty()).filter(r -> "JeiReloadListener".equals(r.getClass().getSimpleName())).map(ISelectiveResourceReloadListener.class::cast).forEach(r -> r.onResourceManagerReload(manager, t -> true));
        }
        recipeManager = null;
        recipesReceived = false;
        tagsReceived = false;
    }
}

