/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.pureore;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.fml.DistExecutor;
import org.apache.logging.log4j.util.Supplier;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.ItemEC;
import sirttas.elementalcraft.nbt.NBTHelper;
import sirttas.elementalcraft.recipe.instrument.PurifierRecipe;

public class PureOreHelper {
    private static final Map<Item, Entry> PURE_ORE_MAP = new HashMap<Item, Entry>();

    public static ItemStack getOre(ItemStack stack) {
        return NBTHelper.readItemStack(NBTHelper.getECTag(stack), "ore");
    }

    public static boolean isValidOre(ItemStack ore) {
        return PURE_ORE_MAP.containsKey(ore.func_77973_b());
    }

    public static ItemStack createPureOre(Item item) {
        ItemStack stack = new ItemStack((IItemProvider)ECItems.pureOre);
        NBTHelper.writeItemStack(NBTHelper.getOrCreateECTag(stack), "ore", new ItemStack((IItemProvider)(PURE_ORE_MAP.containsKey(item) ? PureOreHelper.PURE_ORE_MAP.get((Object)item).ore : item)));
        return stack;
    }

    public static int getColor(ItemStack stack) {
        return Optional.of(stack).map(PureOreHelper::getOre).map(i -> PURE_ORE_MAP.get(i.func_77973_b())).map(o -> o.color).orElse(-1);
    }

    public static List<Item> getOres() {
        return PURE_ORE_MAP.values().stream().distinct().map(o -> o.ore).distinct().collect(Collectors.toList());
    }

    public static List<PurifierRecipe> getRecipes() {
        return PURE_ORE_MAP.entrySet().stream().collect(Collectors.groupingBy(e -> ((Entry)e.getValue()).result, Collectors.mapping(e -> new ItemStack((IItemProvider)e.getKey()), Collectors.toList()))).values().stream().filter(e -> !e.isEmpty()).map(JEIPurifierRecipe::new).collect(Collectors.toList());
    }

    public static void generatePureOres(RecipeManager recipeManager) {
        Map<ResourceLocation, IRecipe<IInventory>> smeltingRecipes = PureOreHelper.makeMutable(recipeManager.func_215366_a(IRecipeType.field_222150_b));
        Map<ResourceLocation, IRecipe<IInventory>> blastingRecipes = PureOreHelper.makeMutable(recipeManager.func_215366_a(IRecipeType.field_222151_c));
        ElementalCraft.LOGGER.info("Pure ore generation started. Ores found: {}", new Supplier[]{() -> Tags.Items.ORES.func_230236_b_().stream().map(o -> o.getRegistryName().toString()).collect(Collectors.joining(", "))});
        for (Item ore : Tags.Items.ORES.func_230236_b_()) {
            PureOreHelper.getRecipe(smeltingRecipes, ore).map(r -> PureOreHelper.addOre(ore, r)).ifPresent(e -> PureOreHelper.getRecipe(blastingRecipes, ore).ifPresent(r -> {
                e.blastingRecipe = r;
            }));
        }
        if (Boolean.TRUE.equals(ECConfig.CONFIG.pureOreSmeltingRecipeInjection.get())) {
            ElementalCraft.LOGGER.info("Pure ore recipe injection");
            try {
                recipeManager.field_199522_d = PureOreHelper.makeMutable(recipeManager.field_199522_d);
                PureOreHelper.inject(recipeManager, IRecipeType.field_222150_b, smeltingRecipes, PureOreHelper::buildSmeltingRecipe);
                PureOreHelper.inject(recipeManager, IRecipeType.field_222151_c, blastingRecipes, PureOreHelper::buildBlastingRecipe);
            }
            catch (Exception e2) {
                ElementalCraft.LOGGER.error("Error in pure ore recipe injection", (Throwable)e2);
            }
        }
        ElementalCraft.LOGGER.info("Pure ore generation ended");
    }

    private static void inject(RecipeManager recipeManager, IRecipeType<?> recipeType, Map<ResourceLocation, IRecipe<IInventory>> map, Function<Entry, AbstractCookingRecipe> func) {
        map.putAll(PURE_ORE_MAP.values().stream().distinct().map(func).filter(Objects::nonNull).collect(Collectors.toMap(IRecipe::func_199560_c, o -> o)));
        recipeManager.field_199522_d.put(recipeType, map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private static Optional<AbstractCookingRecipe> getRecipe(Map<ResourceLocation, IRecipe<IInventory>> map, Item ore) {
        return map.values().stream().filter(r -> ((Ingredient)r.func_192400_c().get(0)).test(new ItemStack((IItemProvider)ore))).filter(AbstractCookingRecipe.class::isInstance).map(AbstractCookingRecipe.class::cast).findAny();
    }

    private static <K, V> Map<K, V> makeMutable(Map<K, V> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static String buildId(ResourceLocation source) {
        return source.func_110624_b() + "_pure_" + source.func_110623_a().replace('/', '_');
    }

    private static AbstractCookingRecipe buildSmeltingRecipe(Entry entry) {
        return new FurnaceRecipe(ElementalCraft.createRL(PureOreHelper.buildId(entry.smeltingRecipe.func_199560_c())), entry.smeltingRecipe.func_193358_e(), (Ingredient)new PureOreCompoundIngredient(entry.ingredients), entry.result, entry.smeltingRecipe.func_222138_b(), entry.smeltingRecipe.func_222137_e());
    }

    private static AbstractCookingRecipe buildBlastingRecipe(Entry entry) {
        return entry.blastingRecipe != null ? new BlastingRecipe(ElementalCraft.createRL(PureOreHelper.buildId(entry.blastingRecipe.func_199560_c())), entry.blastingRecipe.func_193358_e(), (Ingredient)new PureOreCompoundIngredient(entry.ingredients), entry.result, entry.blastingRecipe.func_222138_b(), entry.blastingRecipe.func_222137_e()) : null;
    }

    private static Entry addOre(Item item, AbstractCookingRecipe recipe) {
        for (Entry entry : PURE_ORE_MAP.values()) {
            if (!entry.result.func_77969_a(recipe.func_77571_b()) && !((Ingredient)entry.smeltingRecipe.func_192400_c().get(0)).test(new ItemStack((IItemProvider)item))) continue;
            PURE_ORE_MAP.put(item, entry);
            entry.ingredients.add((Ingredient)new PureOreIngredient(PureOreHelper.createPureOre(item)));
            return entry;
        }
        Entry entry = new Entry(item, recipe);
        PURE_ORE_MAP.put(item, entry);
        return entry;
    }

    private static class JEIPurifierRecipe
    extends PurifierRecipe {
        public JEIPurifierRecipe(List<ItemStack> ores) {
            super(ores.get(0));
            this.input = Ingredient.func_193369_a((ItemStack[])((ItemStack[])ores.stream().toArray(ItemStack[]::new)));
        }
    }

    private static class PureOreCompoundIngredient
    extends CompoundIngredient {
        protected PureOreCompoundIngredient(List<Ingredient> children) {
            super(children);
        }
    }

    private static class PureOreIngredient
    extends NBTIngredient {
        public PureOreIngredient(ItemStack stack) {
            super(stack);
        }
    }

    protected static class Entry {
        Item ore;
        List<Ingredient> ingredients;
        ItemStack result;
        int color;
        AbstractCookingRecipe smeltingRecipe;
        AbstractCookingRecipe blastingRecipe;

        public Entry(Item ore, AbstractCookingRecipe recipe) {
            this.ore = ore;
            this.ingredients = Lists.newArrayList((Object[])new Ingredient[]{new PureOreIngredient(PureOreHelper.createPureOre(ore))});
            this.smeltingRecipe = recipe;
            this.result = recipe.func_77571_b().func_77946_l();
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                this.color = ItemEC.lookupColor(this.result);
            });
        }
    }
}

