/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jei;

import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.infusion.InfusionHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.pureore.PureOreHelper;
import sirttas.elementalcraft.jei.category.BindingRecipeCategory;
import sirttas.elementalcraft.jei.category.InfusionRecipeCategory;
import sirttas.elementalcraft.jei.category.PureInfusionRecipeCategory;
import sirttas.elementalcraft.jei.category.PurificationRecipeCategory;
import sirttas.elementalcraft.jei.category.ToolInfusionRecipeCategory;
import sirttas.elementalcraft.recipe.PureInfusionRecipe;
import sirttas.elementalcraft.recipe.instrument.BinderRecipe;
import sirttas.elementalcraft.recipe.instrument.infusion.AbstractInfusionRecipe;

@JeiPlugin
public class ElementalCraftJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ElementalCraft.createRL("main");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        registry.useNbtForSubtypes(new Item[]{ECItems.scroll});
        registry.useNbtForSubtypes(new Item[]{ECItems.receptacle});
        registry.useNbtForSubtypes(new Item[]{ECItems.pureOre});
        registry.useNbtForSubtypes(new Item[]{ECItems.airElementHolder});
        registry.useNbtForSubtypes(new Item[]{ECItems.earthElementHolder});
        registry.useNbtForSubtypes(new Item[]{ECItems.fireElementHolder});
        registry.useNbtForSubtypes(new Item[]{ECItems.waterElementHolder});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new InfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ToolInfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new BindingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PureInfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PurificationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.fireFurnace), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.fireBlastFurnace), new ResourceLocation[]{VanillaRecipeCategoryUid.BLASTING});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.infuser), new ResourceLocation[]{InfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.infuser), new ResourceLocation[]{ToolInfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.binder), new ResourceLocation[]{BindingRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.pureInfuser), new ResourceLocation[]{PureInfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.purifier), new ResourceLocation[]{PurificationRecipeCategory.UID});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        registry.addRecipes(recipeManager.func_215366_a(AbstractInfusionRecipe.TYPE).values(), InfusionRecipeCategory.UID);
        registry.addRecipes(InfusionHelper.getRecipes(), ToolInfusionRecipeCategory.UID);
        registry.addRecipes(recipeManager.func_215366_a(BinderRecipe.TYPE).values(), BindingRecipeCategory.UID);
        registry.addRecipes(recipeManager.func_215366_a(PureInfusionRecipe.TYPE).values(), PureInfusionRecipeCategory.UID);
        registry.addRecipes(PureOreHelper.getRecipes(), PurificationRecipeCategory.UID);
    }
}

