/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jei.category;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.instrument.binder.TileBinder;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.jei.category.AbstractInstrumentRecipeCategory;
import sirttas.elementalcraft.recipe.instrument.BinderRecipe;

public class BindingRecipeCategory
extends AbstractInstrumentRecipeCategory<TileBinder, BinderRecipe> {
    public static final ResourceLocation UID = ElementalCraft.createRL("binding");
    private static final int RADIUS = 42;
    private final IDrawable icon;
    private final IDrawable overlay;
    private final IDrawable background;
    private ItemStack binder = new ItemStack((IItemProvider)ECItems.binder).func_77946_l();

    public BindingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(132, 100);
        this.icon = guiHelper.createDrawableIngredient((Object)this.binder);
        this.overlay = guiHelper.createDrawable(ElementalCraft.createRL("textures/gui/binding_overlay.png"), 0, 0, 124, 83);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends BinderRecipe> getRecipeClass() {
        return BinderRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"elementalcraft.jei.binding", (Object[])new Object[0]);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(BinderRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(matrixStack, 10, 10);
        this.renderElementGauge(matrixStack, 43, 60, recipe);
        RenderSystem.disableBlend();
    }

    public void setRecipe(IRecipeLayout recipeLayout, BinderRecipe recipe, IIngredients ingredients) {
        int i = 0;
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        for (List input : inputs) {
            double a = Math.toRadians((double)i / (double)inputs.size() * 360.0 + 180.0);
            recipeLayout.getItemStacks().init(i, true, 42 + (int)(-42.0 * Math.sin(a)), 42 + (int)(42.0 * Math.cos(a)));
            recipeLayout.getItemStacks().set(i, input);
            ++i;
        }
        recipeLayout.getItemStacks().init(i, false, 42, 42);
        recipeLayout.getItemStacks().set(i, this.tank);
        recipeLayout.getItemStacks().init(i + 1, false, 42, 26);
        recipeLayout.getItemStacks().set(i + 1, this.binder);
        recipeLayout.getItemStacks().init(i + 2, false, 116, 42);
        recipeLayout.getItemStacks().set(i + 2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

