/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jei.category;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.instrument.infuser.TileInfuser;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.jei.category.AbstractInstrumentRecipeCategory;
import sirttas.elementalcraft.recipe.instrument.infusion.AbstractInfusionRecipe;

public class InfusionRecipeCategory
extends AbstractInstrumentRecipeCategory<TileInfuser, AbstractInfusionRecipe> {
    public static final ResourceLocation UID = ElementalCraft.createRL("infusion");
    private final IDrawable icon;
    private final IDrawable overlay;
    private final IDrawable background;
    private ItemStack infuser = new ItemStack((IItemProvider)ECItems.infuser).func_77946_l();
    protected List<ItemStack> tanks = Lists.newArrayList((Object[])new ItemStack[]{this.tank, new ItemStack((IItemProvider)ECItems.tankSmall).func_77946_l()});

    public InfusionRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(75, 59);
        this.icon = guiHelper.createDrawableIngredient((Object)this.infuser);
        this.overlay = guiHelper.createDrawable(ElementalCraft.createRL("textures/gui/infusion_overlay.png"), 0, 0, 65, 16);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends AbstractInfusionRecipe> getRecipeClass() {
        return AbstractInfusionRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"elementalcraft.jei.infusion", (Object[])new Object[0]);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(AbstractInfusionRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(matrixStack, 8, 20);
        this.renderElementGauge(matrixStack, 31, 42, recipe);
        RenderSystem.disableBlend();
    }

    public void setRecipe(IRecipeLayout recipeLayout, AbstractInfusionRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 0, 0);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(1, false, 30, 24);
        recipeLayout.getItemStacks().set(1, this.tanks);
        recipeLayout.getItemStacks().init(2, false, 30, 8);
        recipeLayout.getItemStacks().set(2, this.infuser);
        recipeLayout.getItemStacks().init(3, false, 59, 0);
        recipeLayout.getItemStacks().set(3, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

