/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.particle;

import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.particle.element.ParticleElementCrafting;
import sirttas.elementalcraft.particle.element.ParticleElementFlow;
import sirttas.elementalcraft.particle.element.ParticleSource;

@OnlyIn(value=Dist.CLIENT)
public class ParticleHelper {
    public static void createSourceParticle(ElementType type, World world, Vector3d pos, Random rand) {
        double x = pos.func_82615_a() + (7.0 + rand.nextDouble() * 2.0) * 0.0625;
        double y = pos.func_82617_b() + 0.3125;
        double z = pos.func_82616_c() + (7.0 + rand.nextDouble() * 2.0) * 0.0625;
        world.func_195594_a(ParticleSource.createData(type), x, y, z, 0.0, 0.0, 0.0);
    }

    public static void createCraftingParticle(ElementType type, World world, Vector3d pos, Random rand) {
        double x = pos.func_82615_a() + (7.0 + rand.nextDouble() * 2.0) * 0.0625;
        double y = pos.func_82617_b() + 0.3125;
        double z = pos.func_82616_c() + (7.0 + rand.nextDouble() * 2.0) * 0.0625;
        IntStream.range(0, 8 + rand.nextInt(5)).forEach(i -> world.func_195594_a(ParticleElementCrafting.createData(type != ElementType.NONE ? type : ElementType.random(rand)), x, y, z, 0.0, 0.0, 0.0));
    }

    public static void createElementFlowParticle(ElementType type, World world, Vector3d pos, Direction direction, int scale, Random rand) {
        double x = pos.func_82615_a() + (5.0 + rand.nextDouble() * 6.0) * 0.0625;
        double y = pos.func_82617_b() + 0.3125;
        double z = pos.func_82616_c() + (5.0 + rand.nextDouble() * 6.0) * 0.0625;
        Vector3d flow = Vector3d.func_237491_b_((Vector3i)direction.func_176734_d().func_176730_m()).func_186678_a(scale == 0 ? 1.0 : (double)scale);
        world.func_195594_a(ParticleElementFlow.createData(type), x, y, z, flow.func_82615_a(), flow.func_82617_b(), flow.func_82616_c());
    }

    public static void createEnderParticle(World world, Vector3d pos, int count, Random rand) {
        for (int i = 0; i < count; ++i) {
            int j = rand.nextInt(2) * 2 - 1;
            int k = rand.nextInt(2) * 2 - 1;
            double d0 = pos.func_82615_a() + 0.5 + 0.25 * (double)j;
            double d1 = pos.func_82617_b() + (double)rand.nextFloat();
            double d2 = pos.func_82616_c() + 0.5 + 0.25 * (double)k;
            double d3 = rand.nextFloat() * (float)j;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.125;
            double d5 = rand.nextFloat() * (float)k;
            world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0, d1, d2, d3, d4, d5);
        }
    }

    public static void createItemBreakParticle(World world, Vector3d pos, Random rand, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vector3d speed = new Vector3d(0.0, rand.nextDouble() * 0.1 + 0.1, 0.0);
            Vector3d loc = pos.func_72441_c(0.0, rand.nextDouble() * 0.2 - 0.2, 0.0);
            if (world instanceof ServerWorld) {
                ((ServerWorld)world).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), loc.field_72450_a, loc.field_72448_b, loc.field_72449_c, 1, speed.field_72450_a, speed.field_72448_b + 0.05, speed.field_72449_c, 0.0);
                continue;
            }
            world.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), loc.field_72450_a, loc.field_72448_b, loc.field_72449_c, speed.field_72450_a, speed.field_72448_b + 0.05, speed.field_72449_c);
        }
    }
}

