/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.extensions.IForgeEffectInstance;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import net.minecraftforge.registries.RegistryBuilder;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.registry.RegistryHelper;
import sirttas.elementalcraft.spell.EffectSpell;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.air.SpellDash;
import sirttas.elementalcraft.spell.air.SpellEnderStrike;
import sirttas.elementalcraft.spell.air.SpellItemPull;
import sirttas.elementalcraft.spell.earth.SpellGavelFall;
import sirttas.elementalcraft.spell.earth.SpellStoneWall;
import sirttas.elementalcraft.spell.earth.SpellTreeFall;
import sirttas.elementalcraft.spell.fire.SpellFireBall;
import sirttas.elementalcraft.spell.fire.SpellFlameCleave;
import sirttas.elementalcraft.spell.fire.SpellInferno;
import sirttas.elementalcraft.spell.water.SpellAnimalGrowth;
import sirttas.elementalcraft.spell.water.SpellPurification;
import sirttas.elementalcraft.spell.water.SpellRipening;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Spells {
    private static final ResourceLocation NAME = ElementalCraft.createRL("spell");
    private static final int MIN_SPELL_ID = 0;
    private static final int MAX_SPELL_ID = 32766;
    @ObjectHolder(value="elementalcraft:none")
    public static Spell none;
    @ObjectHolder(value="elementalcraft:gravelfall")
    public static SpellGavelFall gravelFall;
    @ObjectHolder(value="elementalcraft:stonewall")
    public static SpellStoneWall stoneWall;
    @ObjectHolder(value="elementalcraft:fireball")
    public static SpellFireBall fireBall;
    @ObjectHolder(value="elementalcraft:item_pull")
    public static SpellItemPull itemPull;
    @ObjectHolder(value="elementalcraft:ender_strike")
    public static SpellEnderStrike enderStrike;
    @ObjectHolder(value="elementalcraft:animal_growth")
    public static SpellAnimalGrowth animalGrowth;
    @ObjectHolder(value="elementalcraft:tree_fall")
    public static SpellTreeFall treeFall;
    @ObjectHolder(value="elementalcraft:purification")
    public static SpellPurification purification;
    @ObjectHolder(value="elementalcraft:ripening")
    public static SpellRipening ripening;
    @ObjectHolder(value="elementalcraft:flame_cleave")
    public static SpellFlameCleave flameCleave;
    @ObjectHolder(value="elementalcraft:inferno")
    public static SpellInferno inferno;
    @ObjectHolder(value="elementalcraft:dash")
    public static SpellDash dash;
    @ObjectHolder(value="elementalcraft:heal")
    public static EffectSpell heal;

    @SubscribeEvent
    public static void createSpellRegistry(RegistryEvent.NewRegistry event) {
        new RegistryBuilder().setName(NAME).setIDRange(0, 32766).setType(Spell.class).setDefaultKey(ElementalCraft.createRL("none")).create();
    }

    @SubscribeEvent
    public static void registerSpells(RegistryEvent.Register<Spell> event) {
        IForgeRegistry registry = event.getRegistry();
        RegistryHelper.register(registry, new Spell(Spell.Properties.create(Spell.Type.NONE)), "none");
        RegistryHelper.register(registry, new SpellGavelFall(), "gravelfall");
        RegistryHelper.register(registry, new SpellStoneWall(), "stonewall");
        RegistryHelper.register(registry, new SpellFireBall(), "fireball");
        RegistryHelper.register(registry, new SpellItemPull(), "item_pull");
        RegistryHelper.register(registry, new SpellEnderStrike(), "ender_strike");
        RegistryHelper.register(registry, new SpellAnimalGrowth(), "animal_growth");
        RegistryHelper.register(registry, new SpellTreeFall(), "tree_fall");
        RegistryHelper.register(registry, new SpellPurification(), "purification");
        RegistryHelper.register(registry, new SpellRipening(), "ripening");
        RegistryHelper.register(registry, new SpellFlameCleave(), "flame_cleave");
        RegistryHelper.register(registry, new SpellInferno(), "inferno");
        RegistryHelper.register(registry, new SpellDash(), "dash");
        RegistryHelper.register(registry, new EffectSpell(Spell.Properties.create(Spell.Type.MIXED).elementType(ElementType.WATER).cooldown((Integer)ECConfig.CONFIG.healCooldown.get()).consumeAmount((Integer)ECConfig.CONFIG.healConsumeAmount.get()), new IForgeEffectInstance[]{new EffectInstance(Effects.field_76432_h, 1, 1)}), "heal");
    }
}

