/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.air;

import com.google.common.collect.Multimap;
import java.util.Comparator;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.spell.Spell;

public class SpellEnderStrike
extends Spell {
    public static final String NAME = "ender_strike";

    public SpellEnderStrike() {
        super(Spell.Properties.create(Spell.Type.COMBAT).elementType(ElementType.AIR).cooldown((Integer)ECConfig.CONFIG.enderStrikeCooldown.get()).consumeAmount((Integer)ECConfig.CONFIG.enderStrikeConsumeAmount.get()));
    }

    @Override
    public ActionResultType castOnEntity(Entity sender, Entity target) {
        if (sender instanceof LivingEntity) {
            LivingEntity livingSender = (LivingEntity)sender;
            Vector3d newPos = target.func_213303_ch().func_178787_e(target.func_70040_Z().func_216371_e().func_72432_b());
            if (MinecraftForge.EVENT_BUS.post((Event)new EnderTeleportEvent(livingSender, newPos.field_72450_a, newPos.field_72448_b + 0.5, newPos.field_72449_c, 0.0f))) {
                return ActionResultType.SUCCESS;
            }
            if (livingSender.func_213373_a(newPos.field_72450_a, newPos.field_72448_b + 0.5, newPos.field_72449_c, true)) {
                livingSender.func_200602_a(EntityAnchorArgument.Type.EYES, target.func_213303_ch());
                livingSender.func_130014_f_().func_184148_a(null, livingSender.field_70169_q, livingSender.field_70167_r, livingSender.field_70166_s, SoundEvents.field_187534_aX, livingSender.func_184176_by(), 1.0f, 1.0f);
                livingSender.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                if (livingSender instanceof PlayerEntity) {
                    PlayerEntity playerSender = (PlayerEntity)livingSender;
                    playerSender.func_71059_n(target);
                    playerSender.func_184821_cY();
                    EntityHelper.swingArm(playerSender);
                } else {
                    livingSender.func_70652_k(target);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Override
    public ActionResultType castOnSelf(Entity sender) {
        Vector3d pos = sender.func_213303_ch();
        return sender.func_130014_f_().func_217357_a(LivingEntity.class, new AxisAlignedBB(pos, pos.func_72441_c(1.0, 1.0, 1.0)).func_186662_g(((Double)ECConfig.CONFIG.enderStrikeRange.get()).doubleValue())).stream().filter(IMob.class::isInstance).sorted(Comparator.comparingDouble(e -> pos.func_72438_d(e.func_213303_ch()))).findFirst().map(e -> this.castOnEntity(sender, (Entity)e)).orElse(ActionResultType.PASS);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getOnUseAttributeModifiers() {
        Multimap<Attribute, AttributeModifier> multimap = super.getOnUseAttributeModifiers();
        multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "Weapon modifier", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        multimap.put((Object)((Attribute)ForgeMod.REACH_DISTANCE.get()), (Object)new AttributeModifier(REACH_DISTANCE_MODIFIER, "Reach distance modifier", 5.0, AttributeModifier.Operation.ADDITION));
        return multimap;
    }
}

