/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.earth;

import java.util.ArrayDeque;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.spell.Spell;

public class SpellTreeFall
extends Spell {
    public static final String NAME = "tree_fall";

    public SpellTreeFall() {
        super(Spell.Properties.create(Spell.Type.UTILITY).elementType(ElementType.EARTH).cooldown((Integer)ECConfig.CONFIG.treeFallCooldown.get()).consumeAmount((Integer)ECConfig.CONFIG.treeFallConsumeAmount.get()));
    }

    private boolean isValidBlock(Block block) {
        return BlockTags.field_200031_h.func_230235_a_((Object)block) || BlockTags.field_206952_E.func_230235_a_((Object)block);
    }

    private void cutTree(World world, BlockPos target) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.offer(target);
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.poll();
            Block block = world.func_180495_p(pos).func_177230_c();
            if (!this.isValidBlock(block) || !(pos.func_177951_i((Vector3i)target) <= 225.0)) continue;
            world.func_175655_b(pos, true);
            Stream.of(Direction.values()).filter(d -> d != Direction.DOWN).forEach(d -> queue.offer(pos.func_177972_a(d)));
        }
    }

    @Override
    public ActionResultType castOnBlock(Entity sender, BlockPos target) {
        World world = sender.func_130014_f_();
        if (this.isValidBlock(world.func_180495_p(target).func_177230_c())) {
            this.cutTree(world, target);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

