/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.fire;

import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import sirttas.elementalcraft.ElementType;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.spell.Spell;

public class SpellFlameCleave
extends Spell {
    public static final String NAME = "flame_cleave";

    public SpellFlameCleave() {
        super(Spell.Properties.create(Spell.Type.COMBAT).elementType(ElementType.FIRE).cooldown((Integer)ECConfig.CONFIG.flameCleaveCooldown.get()).consumeAmount((Integer)ECConfig.CONFIG.flameCleaveConsumeAmount.get()));
    }

    @Override
    public ActionResultType castOnSelf(Entity sender) {
        World world = sender.func_130014_f_();
        Double range = (Double)ECConfig.CONFIG.flameCleaveRange.get();
        if (sender instanceof LivingEntity) {
            LivingEntity livingSender = (LivingEntity)sender;
            float damageBase = (float)livingSender.func_110148_a(Attributes.field_233823_f_).func_111126_e();
            float damageMult = 1.0f + EnchantmentHelper.func_191527_a((LivingEntity)livingSender);
            for (LivingEntity target : world.func_217357_a(LivingEntity.class, livingSender.func_174813_aQ().func_72314_b(range + 1.0, 0.25, range + 1.0))) {
                this.hitTarget(livingSender, target, damageBase, damageMult);
            }
            world.func_184148_a(null, livingSender.func_226277_ct_(), livingSender.func_226278_cu_(), livingSender.func_226281_cx_(), SoundEvents.field_187730_dW, livingSender.func_184176_by(), 1.0f, 1.0f);
            if (livingSender instanceof PlayerEntity) {
                PlayerEntity playerSender = (PlayerEntity)livingSender;
                playerSender.func_184810_cG();
                playerSender.func_184821_cY();
                EntityHelper.swingArm(playerSender);
            }
            world.func_217378_a(null, 2004, livingSender.func_233580_cy_(), 0);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private void hitTarget(LivingEntity sender, LivingEntity target, float damageBase, float damageMult) {
        float damage;
        Double range = (Double)ECConfig.CONFIG.flameCleaveRange.get();
        if (!(target == sender || sender.func_184191_r((Entity)target) || target instanceof ArmorStandEntity && ((ArmorStandEntity)target).func_181026_s() || !(sender.func_70068_e((Entity)target) < range * range) || !((damage = damageMult * (damageBase + EnchantmentHelper.func_152377_a((ItemStack)sender.func_184614_ca(), (CreatureAttribute)target.func_70668_bt()))) > 0.0f))) {
            target.func_233627_a_(0.4f, sender.func_226277_ct_() - target.func_226277_ct_(), sender.func_226281_cx_() - target.func_226281_cx_());
            target.func_70097_a(sender instanceof PlayerEntity ? DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)sender)) : DamageSource.func_76358_a((LivingEntity)sender), damage);
            target.func_70015_d(5);
            EnchantmentHelper.func_151384_a((LivingEntity)target, (Entity)sender);
            EnchantmentHelper.func_151385_b((LivingEntity)sender, (Entity)target);
            this.hitWithItem(sender, target);
        }
    }

    private void hitWithItem(LivingEntity sender, LivingEntity target) {
        ItemStack stack = sender.func_184614_ca();
        if (!stack.func_190926_b() && sender instanceof PlayerEntity) {
            ItemStack copy = stack.func_77946_l();
            stack.func_77973_b().func_77644_a(stack, target, sender);
            if (stack.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)((PlayerEntity)sender), (ItemStack)copy, (Hand)Hand.MAIN_HAND);
                sender.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            }
        }
    }
}

