/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft;

import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sirttas.dpanvil.api.data.DataManagerFactory;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.api.imc.DataManagerIMC;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrade;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.pureore.PureOreManager;
import sirttas.elementalcraft.loot.function.ECLootFunctions;
import sirttas.elementalcraft.network.message.MessageHandler;
import sirttas.elementalcraft.network.proxy.ClientProxy;
import sirttas.elementalcraft.network.proxy.IProxy;
import sirttas.elementalcraft.rune.Rune;
import sirttas.elementalcraft.rune.handler.CapabilityRuneHandler;
import sirttas.elementalcraft.spell.SpellTickManager;
import sirttas.elementalcraft.spell.properties.SpellProperties;
import sirttas.elementalcraft.world.feature.ECFeatures;

@Mod(value="elementalcraft")
public class ElementalCraft {
    public static final String MODID = "elementalcraft";
    public static final Logger LOGGER = LogManager.getLogger((String)"elementalcraft");
    public static final PureOreManager PURE_ORE_MANAGER = new PureOreManager();
    public static final IDataManager<ShrineUpgrade> SHREINE_UPGRADE_MANAGER = DataManagerFactory.simple(ShrineUpgrade.class, (String)"elementalcraft_shrine_upgrades");
    public static final IDataManager<SpellProperties> SPELL_PROPERTIES_MANAGER = DataManagerFactory.defaulted(SpellProperties.class, (String)"elementalcraft_spell_properties", (Object)SpellProperties.NONE);
    public static final IDataManager<Rune> RUNE_MANAGER = DataManagerFactory.simple(Rune.class, (String)"elementalcraft_runes");
    private IProxy proxy = (IProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> () -> new IProxy(){});

    public ElementalCraft() {
        this.proxy.registerHandlers();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        MinecraftForge.EVENT_BUS.addListener(SpellTickManager::serverTick);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, ECFeatures::onBiomeLoad);
        MinecraftForge.EVENT_BUS.addListener(PURE_ORE_MANAGER::reload);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ECConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ECConfig.CLIENT_SPEC);
    }

    public static ResourceLocation createRL(String name) {
        if (name.contains(":")) {
            return new ResourceLocation(name);
        }
        return new ResourceLocation(MODID, name);
    }

    private void setup(FMLCommonSetupEvent event) {
        MessageHandler.setup();
        ECLootFunctions.setup();
        CapabilityRuneHandler.register();
        CapabilityElementStorage.register();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        DataManagerIMC.enqueue(() -> new DataManagerIMC(ElementalCraft.createRL("shrine_upgrades"), SHREINE_UPGRADE_MANAGER).withCodec(ShrineUpgrade.CODEC));
        DataManagerIMC.enqueue(() -> new DataManagerIMC(ElementalCraft.createRL("spell_properties"), SPELL_PROPERTIES_MANAGER).withCodec(SpellProperties.CODEC));
        DataManagerIMC.enqueue(() -> new DataManagerIMC(ElementalCraft.createRL("runes"), RUNE_MANAGER).withCodec(Rune.CODEC));
    }
}

