/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.storage;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.LazyOptional;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.ElementStorage;
import sirttas.elementalcraft.api.element.storage.EmptyElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.block.tile.TileEntityHelper;

public class CapabilityElementStorage {
    @CapabilityInject(value=IElementStorage.class)
    public static final Capability<IElementStorage> ELEMENT_STORAGE_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IElementStorage.class, (Capability.IStorage)new Capability.IStorage<IElementStorage>(){

            public INBT writeNBT(Capability<IElementStorage> capability, IElementStorage instance, Direction side) {
                CompoundNBT compound = new CompoundNBT();
                compound.func_74778_a("element_type", instance.getElementType().func_176610_l());
                compound.func_74768_a("element_amount", instance.getElementAmount());
                compound.func_74768_a("element_capacity", instance.getElementCapacity());
                return compound;
            }

            public void readNBT(Capability<IElementStorage> capability, IElementStorage instance, Direction side, INBT base) {
                if (!(instance instanceof ElementStorage) || !(base instanceof CompoundNBT)) {
                    throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
                }
                ElementStorage storage = (ElementStorage)instance;
                CompoundNBT compound = (CompoundNBT)base;
                storage.elementType = ElementType.byName(compound.func_74779_i("element_type"));
                storage.elementAmount = compound.func_74762_e("element_amount");
                storage.elementCapacity = compound.func_74762_e("element_capacity");
            }
        }, () -> new ElementStorage(100000));
    }

    public static IElementStorage getElementStorageAt(IWorldReader world, BlockPos pos) {
        return TileEntityHelper.getTileEntity((IBlockReader)world, pos).map(t -> (IElementStorage)CapabilityElementStorage.get(t).orElse((Object)EmptyElementStorage.INSTANCE)).orElse(EmptyElementStorage.INSTANCE);
    }

    public static LazyOptional<IElementStorage> get(TileEntity tileEntity) {
        return tileEntity.getCapability(ELEMENT_STORAGE_CAPABILITY);
    }
}

