/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.storage;

import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;

public class ElementStorage
implements IElementStorage {
    protected int elementAmount;
    protected int elementCapacity;
    protected ElementType elementType;
    private final Runnable syncCallback;

    public ElementStorage(int elementCapacity) {
        this(elementCapacity, null);
    }

    public ElementStorage(int elementCapacity, Runnable syncCallback) {
        this.syncCallback = syncCallback;
        this.elementCapacity = elementCapacity;
        this.elementAmount = 0;
        this.elementType = ElementType.NONE;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public int getElementCapacity() {
        return this.elementCapacity;
    }

    @Override
    public int insertElement(int count, ElementType type, boolean simulate) {
        if (type != this.elementType && this.elementType != ElementType.NONE) {
            return count - this.extractElement(count, simulate);
        }
        int newCount = Math.min(this.elementAmount + count, this.elementCapacity);
        int ret = count - newCount + this.elementAmount;
        if (!simulate) {
            this.elementAmount = newCount;
            if (this.elementType == ElementType.NONE) {
                this.elementType = type;
            }
        }
        this.markDirty();
        return ret;
    }

    @Override
    public int extractElement(int count, ElementType type, boolean simulate) {
        if (type != this.elementType) {
            return 0;
        }
        int newCount = Math.max(this.elementAmount - count, 0);
        int ret = this.elementAmount - newCount;
        if (!simulate) {
            this.elementAmount = newCount;
            if (this.elementAmount <= 0) {
                this.elementType = ElementType.NONE;
            }
        }
        this.markDirty();
        return ret;
    }

    public void markDirty() {
        if (this.syncCallback != null) {
            this.syncCallback.run();
        }
    }
}

