/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.storage;

import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;

public interface IElementStorage
extends IElementTypeProvider {
    public int getElementAmount();

    public int getElementCapacity();

    public int insertElement(int var1, ElementType var2, boolean var3);

    public int extractElement(int var1, ElementType var2, boolean var3);

    default public int insertElement(int count, boolean simulate) {
        return this.insertElement(count, this.getElementType(), simulate);
    }

    default public int extractElement(int count, boolean simulate) {
        return this.extractElement(count, this.getElementType(), simulate);
    }

    default public int transferTo(IElementStorage other, int count) {
        ElementType type = this.getElementType();
        int amount = this.extractElement(count, type, false);
        return count - amount + other.insertElement(amount, type, false);
    }

    default public boolean canPipeInsert() {
        return true;
    }

    default public boolean canPipeExtract() {
        return true;
    }

    default public boolean doesRenderGauge() {
        return false;
    }

    default public boolean isEmpty() {
        return this.getElementType() == ElementType.NONE || this.getElementAmount() <= 0;
    }
}

