/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.pureore.injector;

import com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import sirttas.elementalcraft.api.pureore.PureOreException;

public abstract class PureOreRecipeInjector<C extends IInventory, T extends IRecipe<C>>
extends ForgeRegistryEntry<PureOreRecipeInjector<?, ? extends IRecipe<?>>> {
    public static final IForgeRegistry<PureOreRecipeInjector<?, ? extends IRecipe<?>>> REGISTRY = RegistryManager.ACTIVE.getRegistry(PureOreRecipeInjector.class);
    private final IRecipeType<T> recipeType;
    private Map<ResourceLocation, T> recipes;
    private RecipeManager recipeManager;

    protected PureOreRecipeInjector(IRecipeType<T> recipeType) {
        this.recipeType = recipeType;
        this.recipes = null;
        this.recipeManager = null;
    }

    public static String buildRecipeId(ResourceLocation source) {
        return source.func_110624_b() + "_pure_" + source.func_110623_a().replace('/', '_');
    }

    public void init(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
        this.recipes = recipeManager.func_215366_a(this.recipeType).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (IRecipe)entry.getValue()));
    }

    public boolean filter(T recipe, ItemStack stack) {
        try {
            return ((Ingredient)recipe.func_192400_c().get(0)).test(stack);
        }
        catch (Exception e) {
            throw new PureOreException(MessageFormat.format("Error while reading ingredients for recipe {0}. Pleanse setup a custom filter for {1}", new Object[]{recipe.func_199560_c(), this}), e);
        }
    }

    public void inject(Map<ResourceLocation, T> map) {
        this.recipeManager.field_199522_d.put(this.recipeType, (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public ItemStack getRecipeOutput(T recipe) {
        return recipe.func_77571_b();
    }

    public abstract T build(T var1, Ingredient var2);

    public Map<ResourceLocation, T> getRecipes() {
        return this.recipes;
    }

    public Optional<T> getRecipe(Item ore) {
        return this.getRecipes().values().stream().map(recipe -> recipe).filter(recipe -> this.filter(recipe, new ItemStack((IItemProvider)ore))).findAny();
    }

    public IRecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    public ResourceLocation getRecipeTypeRegistryName() {
        return Registry.field_218367_H.func_177774_c(this.recipeType);
    }

    public String toString() {
        return this.getRecipeTypeRegistryName().toString();
    }
}

