/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.inscriber;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import sirttas.elementalcraft.block.BlockECContainer;
import sirttas.elementalcraft.block.instrument.inscriber.TileInscriber;
import sirttas.elementalcraft.inventory.ECInventoryHelper;
import sirttas.elementalcraft.item.ECItems;

public class BlockInscriber
extends BlockECContainer {
    public static final String NAME = "inscriber";
    private static final VoxelShape BASE_1 = Block.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape CONNECTION = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
    private static final VoxelShape BASE_PIPE_1 = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)3.0, (double)3.0);
    private static final VoxelShape BACK_BASE_PIPE_1 = Block.func_208617_a((double)1.0, (double)4.0, (double)1.0, (double)3.0, (double)5.0, (double)3.0);
    private static final VoxelShape BASE_PIPE_2 = Block.func_208617_a((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)3.0);
    private static final VoxelShape BACK_BASE_PIPE_2 = Block.func_208617_a((double)13.0, (double)4.0, (double)1.0, (double)15.0, (double)5.0, (double)3.0);
    private static final VoxelShape BASE_PIPE_3 = Block.func_208617_a((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)15.0);
    private static final VoxelShape BACK_BASE_PIPE_3 = Block.func_208617_a((double)1.0, (double)4.0, (double)13.0, (double)3.0, (double)5.0, (double)15.0);
    private static final VoxelShape BASE_PIPE_4 = Block.func_208617_a((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)3.0, (double)15.0);
    private static final VoxelShape BACK_BASE_PIPE_4 = Block.func_208617_a((double)13.0, (double)4.0, (double)13.0, (double)15.0, (double)5.0, (double)15.0);
    private static final VoxelShape BASE_SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{CONNECTION, BASE_PIPE_1, BASE_PIPE_2, BASE_PIPE_3, BASE_PIPE_4});
    private static final VoxelShape BACK_BASE_NORTH = Block.func_208617_a((double)0.0, (double)3.0, (double)12.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape BACK_PIPE_1_NORTH = Block.func_208617_a((double)4.0, (double)2.0, (double)13.0, (double)6.0, (double)15.0, (double)15.0);
    private static final VoxelShape BACK_PIPE_2_NORTH = Block.func_208617_a((double)10.0, (double)2.0, (double)13.0, (double)12.0, (double)15.0, (double)15.0);
    private static final VoxelShape BACK_NORTH = VoxelShapes.func_216384_a((VoxelShape)BACK_BASE_NORTH, (VoxelShape[])new VoxelShape[]{BACK_BASE_PIPE_3, BACK_BASE_PIPE_4, BACK_PIPE_1_NORTH, BACK_PIPE_2_NORTH});
    private static final VoxelShape PLATE_1_NORTH = Block.func_208617_a((double)1.0, (double)2.0, (double)8.0, (double)15.0, (double)5.0, (double)11.0);
    private static final VoxelShape PLATE_2_NORTH = Block.func_208617_a((double)1.0, (double)5.0, (double)9.0, (double)15.0, (double)8.0, (double)12.0);
    private static final VoxelShape PLATE_3_NORTH = Block.func_208617_a((double)1.0, (double)8.0, (double)10.0, (double)15.0, (double)11.0, (double)13.0);
    private static final VoxelShape PLATE_4_NORTH = Block.func_208617_a((double)1.0, (double)11.0, (double)11.0, (double)15.0, (double)14.0, (double)14.0);
    private static final VoxelShape PLATE_5_NORTH = Block.func_208617_a((double)1.0, (double)14.0, (double)12.0, (double)15.0, (double)17.0, (double)15.0);
    private static final VoxelShape PLATE_NORTH = VoxelShapes.func_216384_a((VoxelShape)PLATE_1_NORTH, (VoxelShape[])new VoxelShape[]{PLATE_2_NORTH, PLATE_3_NORTH, PLATE_4_NORTH, PLATE_5_NORTH});
    private static final VoxelShape BACK_BASE_SOUTH = Block.func_208617_a((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0);
    private static final VoxelShape BACK_PIPE_1_SOUTH = Block.func_208617_a((double)4.0, (double)2.0, (double)1.0, (double)6.0, (double)15.0, (double)3.0);
    private static final VoxelShape BACK_PIPE_2_SOUTH = Block.func_208617_a((double)10.0, (double)2.0, (double)1.0, (double)12.0, (double)15.0, (double)3.0);
    private static final VoxelShape BACK_SOUTH = VoxelShapes.func_216384_a((VoxelShape)BACK_BASE_SOUTH, (VoxelShape[])new VoxelShape[]{BACK_BASE_PIPE_1, BACK_BASE_PIPE_2, BACK_PIPE_1_SOUTH, BACK_PIPE_2_SOUTH});
    private static final VoxelShape PLATE_1_SOUTH = Block.func_208617_a((double)1.0, (double)2.0, (double)5.0, (double)15.0, (double)5.0, (double)8.0);
    private static final VoxelShape PLATE_2_SOUTH = Block.func_208617_a((double)1.0, (double)5.0, (double)4.0, (double)15.0, (double)8.0, (double)7.0);
    private static final VoxelShape PLATE_3_SOUTH = Block.func_208617_a((double)1.0, (double)8.0, (double)3.0, (double)15.0, (double)11.0, (double)6.0);
    private static final VoxelShape PLATE_4_SOUTH = Block.func_208617_a((double)1.0, (double)11.0, (double)2.0, (double)15.0, (double)14.0, (double)5.0);
    private static final VoxelShape PLATE_5_SOUTH = Block.func_208617_a((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)17.0, (double)4.0);
    private static final VoxelShape PLATE_SOUTH = VoxelShapes.func_216384_a((VoxelShape)PLATE_1_SOUTH, (VoxelShape[])new VoxelShape[]{PLATE_2_SOUTH, PLATE_3_SOUTH, PLATE_4_SOUTH, PLATE_5_SOUTH});
    private static final VoxelShape BACK_BASE_WEST = Block.func_208617_a((double)12.0, (double)3.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape BACK_PIPE_1_WEST = Block.func_208617_a((double)13.0, (double)2.0, (double)4.0, (double)15.0, (double)15.0, (double)6.0);
    private static final VoxelShape BACK_PIPE_2_WEST = Block.func_208617_a((double)13.0, (double)2.0, (double)10.0, (double)15.0, (double)15.0, (double)12.0);
    private static final VoxelShape BACK_WEST = VoxelShapes.func_216384_a((VoxelShape)BACK_BASE_WEST, (VoxelShape[])new VoxelShape[]{BACK_BASE_PIPE_2, BACK_BASE_PIPE_4, BACK_PIPE_1_WEST, BACK_PIPE_2_WEST});
    private static final VoxelShape PLATE_1_WEST = Block.func_208617_a((double)8.0, (double)2.0, (double)1.0, (double)11.0, (double)5.0, (double)15.0);
    private static final VoxelShape PLATE_2_WEST = Block.func_208617_a((double)9.0, (double)5.0, (double)1.0, (double)12.0, (double)8.0, (double)15.0);
    private static final VoxelShape PLATE_3_WEST = Block.func_208617_a((double)10.0, (double)8.0, (double)1.0, (double)13.0, (double)11.0, (double)15.0);
    private static final VoxelShape PLATE_4_WEST = Block.func_208617_a((double)11.0, (double)11.0, (double)1.0, (double)14.0, (double)14.0, (double)15.0);
    private static final VoxelShape PLATE_5_WEST = Block.func_208617_a((double)12.0, (double)14.0, (double)1.0, (double)15.0, (double)17.0, (double)15.0);
    private static final VoxelShape PLATE_WEST = VoxelShapes.func_216384_a((VoxelShape)PLATE_1_WEST, (VoxelShape[])new VoxelShape[]{PLATE_2_WEST, PLATE_3_WEST, PLATE_4_WEST, PLATE_5_WEST});
    private static final VoxelShape BACK_BASE_EAST = Block.func_208617_a((double)0.0, (double)3.0, (double)0.0, (double)4.0, (double)4.0, (double)16.0);
    private static final VoxelShape BACK_PIPE_1_EAST = Block.func_208617_a((double)1.0, (double)2.0, (double)4.0, (double)3.0, (double)15.0, (double)6.0);
    private static final VoxelShape BACK_PIPE_2_EAST = Block.func_208617_a((double)1.0, (double)2.0, (double)10.0, (double)3.0, (double)15.0, (double)12.0);
    private static final VoxelShape BACK_EAST = VoxelShapes.func_216384_a((VoxelShape)BACK_BASE_EAST, (VoxelShape[])new VoxelShape[]{BACK_BASE_PIPE_1, BACK_BASE_PIPE_3, BACK_PIPE_1_EAST, BACK_PIPE_2_EAST});
    private static final VoxelShape PLATE_1_EAST = Block.func_208617_a((double)5.0, (double)2.0, (double)1.0, (double)8.0, (double)5.0, (double)15.0);
    private static final VoxelShape PLATE_2_EAST = Block.func_208617_a((double)4.0, (double)5.0, (double)1.0, (double)7.0, (double)8.0, (double)15.0);
    private static final VoxelShape PLATE_3_EAST = Block.func_208617_a((double)3.0, (double)8.0, (double)1.0, (double)6.0, (double)6.0, (double)15.0);
    private static final VoxelShape PLATE_4_EAST = Block.func_208617_a((double)2.0, (double)11.0, (double)1.0, (double)5.0, (double)14.0, (double)15.0);
    private static final VoxelShape PLATE_5_EAST = Block.func_208617_a((double)1.0, (double)14.0, (double)1.0, (double)4.0, (double)17.0, (double)15.0);
    private static final VoxelShape PLATE_EAST = VoxelShapes.func_216384_a((VoxelShape)PLATE_1_EAST, (VoxelShape[])new VoxelShape[]{PLATE_2_EAST, PLATE_3_EAST, PLATE_4_EAST, PLATE_5_EAST});
    private static final VoxelShape NORTH_SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{BACK_NORTH, PLATE_NORTH});
    private static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{BACK_SOUTH, PLATE_SOUTH});
    private static final VoxelShape WEST_SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{BACK_WEST, PLATE_WEST});
    private static final VoxelShape EAST_SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{BACK_EAST, PLATE_EAST});
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public BlockInscriber() {
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileInscriber();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileInscriber inscriber = (TileInscriber)world.func_175625_s(pos);
        ItemStack heldItem = player.func_184586_b(hand);
        IItemHandler inv = ECInventoryHelper.getItemHandlerAt((IBlockReader)world, pos, null);
        if (inscriber != null) {
            if (heldItem.func_77973_b() == ECItems.chisel && !inscriber.isLocked()) {
                return this.makeProgress(player, hand, inscriber, heldItem);
            }
            if ((inscriber.isLocked() || heldItem.func_190926_b() || player.func_225608_bj_()) && !inscriber.getInventory().func_191420_l()) {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    this.onSlotActivated(inv, player, ItemStack.field_190927_a, i);
                }
                return ActionResultType.SUCCESS;
            }
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (!inv.getStackInSlot(i).func_190926_b() || !this.onSlotActivated(inv, player, heldItem, i).func_226247_b_()) continue;
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    private ActionResultType makeProgress(PlayerEntity player, Hand hand, TileInscriber inscriber, ItemStack heldItem) {
        if (inscriber.makeProgress()) {
            if (heldItem.func_77984_f() && !player.func_184812_l_()) {
                heldItem.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(hand));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return BASE_SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }
}

