/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.purifier;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.BlockECContainer;
import sirttas.elementalcraft.block.instrument.purifier.TilePurifier;
import sirttas.elementalcraft.inventory.ECInventoryHelper;

public class BlockPurifier
extends BlockECContainer {
    public static final String NAME = "purifier";
    private static final VoxelShape OVEN_SLAB = Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape OVEN_SLAB_2 = Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape CONNECTION = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0);
    private static final VoxelShape PILLAT_1 = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)10.0, (double)3.0);
    private static final VoxelShape PILLAT_2 = Block.func_208617_a((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)3.0);
    private static final VoxelShape PILLAT_3 = Block.func_208617_a((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)10.0, (double)15.0);
    private static final VoxelShape PILLAT_4 = Block.func_208617_a((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)10.0, (double)15.0);
    private static final VoxelShape MAIN_SHAPE = VoxelShapes.func_216384_a((VoxelShape)OVEN_SLAB, (VoxelShape[])new VoxelShape[]{OVEN_SLAB_2, CONNECTION, PILLAT_1, PILLAT_2, PILLAT_3, PILLAT_4});
    private static final VoxelShape NORTH_EMPTY_SPACE = Block.func_208617_a((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0);
    private static final VoxelShape NORTH_OVEN_BLOCK = Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)10.0, (double)7.0);
    private static final VoxelShape NORTH_OVEN_BLOCK_2 = Block.func_208617_a((double)6.0, (double)4.0, (double)7.0, (double)10.0, (double)8.0, (double)11.0);
    private static final VoxelShape NORTH_OVEN = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)NORTH_OVEN_BLOCK, (VoxelShape)NORTH_OVEN_BLOCK_2), (VoxelShape)NORTH_EMPTY_SPACE, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape SOUTH_EMPTY_SPACE = Block.func_208617_a((double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0);
    private static final VoxelShape SOUTH_OVEN_BLOCK = Block.func_208617_a((double)4.0, (double)4.0, (double)9.0, (double)12.0, (double)10.0, (double)16.0);
    private static final VoxelShape SOUTH_OVEN_BLOCK_2 = Block.func_208617_a((double)6.0, (double)4.0, (double)5.0, (double)10.0, (double)8.0, (double)9.0);
    private static final VoxelShape SOUTH_OVEN = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)SOUTH_OVEN_BLOCK, (VoxelShape)SOUTH_OVEN_BLOCK_2), (VoxelShape)SOUTH_EMPTY_SPACE, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape WEST_EMPTY_SPACE = Block.func_208617_a((double)0.0, (double)4.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0);
    private static final VoxelShape WEST_OVEN_BLOCK = Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)7.0, (double)10.0, (double)12.0);
    private static final VoxelShape WEST_OVEN_BLOCK_2 = Block.func_208617_a((double)7.0, (double)4.0, (double)6.0, (double)11.0, (double)8.0, (double)10.0);
    private static final VoxelShape WEST_OVEN = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)WEST_OVEN_BLOCK, (VoxelShape)WEST_OVEN_BLOCK_2), (VoxelShape)WEST_EMPTY_SPACE, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape EAST_EMPTY_SPACE = Block.func_208617_a((double)12.0, (double)4.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0);
    private static final VoxelShape EAST_OVEN_BLOCK = Block.func_208617_a((double)9.0, (double)4.0, (double)4.0, (double)16.0, (double)10.0, (double)12.0);
    private static final VoxelShape EAST_OVEN_BLOCK_2 = Block.func_208617_a((double)5.0, (double)4.0, (double)6.0, (double)9.0, (double)8.0, (double)10.0);
    private static final VoxelShape EAST_OVEN = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)EAST_OVEN_BLOCK, (VoxelShape)EAST_OVEN_BLOCK_2), (VoxelShape)EAST_EMPTY_SPACE, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape NORTH_SHAPE = VoxelShapes.func_197872_a((VoxelShape)MAIN_SHAPE, (VoxelShape)NORTH_OVEN);
    private static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_197872_a((VoxelShape)MAIN_SHAPE, (VoxelShape)SOUTH_OVEN);
    private static final VoxelShape EAST_SHAPE = VoxelShapes.func_197872_a((VoxelShape)MAIN_SHAPE, (VoxelShape)EAST_OVEN);
    private static final VoxelShape WEST_SHAPE = VoxelShapes.func_197872_a((VoxelShape)MAIN_SHAPE, (VoxelShape)WEST_OVEN);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public BlockPurifier() {
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TilePurifier();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TilePurifier purifier = (TilePurifier)world.func_175625_s(pos);
        IItemHandler inv = ECInventoryHelper.getItemHandlerAt((IBlockReader)world, pos, null);
        ItemStack heldItem = player.func_184586_b(hand);
        if (purifier != null) {
            if (!purifier.getInventory().func_70301_a(1).func_190926_b()) {
                return this.onSlotActivated(inv, player, ItemStack.field_190927_a, 1);
            }
            if (heldItem.func_190926_b() || ElementalCraft.PURE_ORE_MANAGER.isValidOre(heldItem)) {
                return this.onSlotActivated(inv, player, heldItem, 0);
            }
        }
        return ActionResultType.PASS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return MAIN_SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }
}

