/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.DistExecutor;
import sirttas.elementalcraft.block.BlockECTileProvider;
import sirttas.elementalcraft.block.pipe.TileElementPipe;

public class BlockElementPipe
extends BlockECTileProvider {
    public static final String NAME = "elementpipe";
    public static final String NAME_IMPAIRED = "elementpipe_impaired";
    public static final String NAME_IMPROVED = "elementpipe_improved";
    private static final VoxelShape BASE_SHAPE = Block.func_208617_a((double)6.5, (double)6.5, (double)6.5, (double)9.5, (double)9.5, (double)9.5);
    private static final VoxelShape WEST_SHAPE = Block.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)6.5, (double)9.0, (double)9.0);
    private static final VoxelShape DOWN_SHAPE = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.5, (double)9.0);
    private static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)6.5);
    private static final VoxelShape EAST_SHAPE = Block.func_208617_a((double)9.5, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private static final VoxelShape UP_SHAPE = Block.func_208617_a((double)7.0, (double)9.5, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)7.0, (double)7.0, (double)9.5, (double)9.0, (double)9.0, (double)16.0);
    private static final List<VoxelShape> SHAPES = ImmutableList.of((Object)EAST_SHAPE, (Object)NORTH_SHAPE, (Object)WEST_SHAPE, (Object)SOUTH_SHAPE, (Object)UP_SHAPE, (Object)DOWN_SHAPE, (Object)BASE_SHAPE);
    public static final BooleanProperty NORTH = BlockStateProperties.field_208151_D;
    public static final BooleanProperty EAST = BlockStateProperties.field_208152_E;
    public static final BooleanProperty SOUTH = BlockStateProperties.field_208153_F;
    public static final BooleanProperty WEST = BlockStateProperties.field_208154_G;
    public static final BooleanProperty UP = BlockStateProperties.field_208149_B;
    public static final BooleanProperty DOWN = BlockStateProperties.field_208150_C;
    public static final BooleanProperty NORTH_EXTRACT = BooleanProperty.func_177716_a((String)"north_extract");
    public static final BooleanProperty EAST_EXTRACT = BooleanProperty.func_177716_a((String)"east_extract");
    public static final BooleanProperty SOUTH_EXTRACT = BooleanProperty.func_177716_a((String)"south_extract");
    public static final BooleanProperty WEST_EXTRACT = BooleanProperty.func_177716_a((String)"west_extract");
    public static final BooleanProperty UP_EXTRACT = BooleanProperty.func_177716_a((String)"up_extract");
    public static final BooleanProperty DOWN_EXTRACT = BooleanProperty.func_177716_a((String)"down_extract");
    private int maxTransferAmount;

    public BlockElementPipe(int maxTransferAmount) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_226896_b_().func_200944_c());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTH_EXTRACT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST_EXTRACT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH_EXTRACT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST_EXTRACT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP_EXTRACT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN_EXTRACT, (Comparable)Boolean.valueOf(false)));
        this.maxTransferAmount = maxTransferAmount;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN, NORTH_EXTRACT, SOUTH_EXTRACT, EAST_EXTRACT, WEST_EXTRACT, UP_EXTRACT, DOWN_EXTRACT});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileElementPipe(this.maxTransferAmount);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        ((TileElementPipe)worldIn.func_175625_s(pos)).refresh();
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        ((TileElementPipe)worldIn.func_175625_s(pos)).refresh();
    }

    private boolean compareShapes(VoxelShape shape1, VoxelShape shape2) {
        return shape1.func_197752_a().equals((Object)shape2.func_197752_a());
    }

    private Direction getFace(VoxelShape shape, BlockRayTraceResult hit) {
        if (this.compareShapes(shape, DOWN_SHAPE)) {
            return Direction.DOWN;
        }
        if (this.compareShapes(shape, UP_SHAPE)) {
            return Direction.UP;
        }
        if (this.compareShapes(shape, NORTH_SHAPE)) {
            return Direction.NORTH;
        }
        if (this.compareShapes(shape, SOUTH_SHAPE)) {
            return Direction.SOUTH;
        }
        if (this.compareShapes(shape, WEST_SHAPE)) {
            return Direction.WEST;
        }
        if (this.compareShapes(shape, EAST_SHAPE)) {
            return Direction.EAST;
        }
        if (shape == BASE_SHAPE) {
            return hit.func_216354_b();
        }
        return null;
    }

    boolean isRendered(VoxelShape shape, BlockState state) {
        if (state.func_177230_c() == this) {
            if (this.compareShapes(shape, BASE_SHAPE)) {
                return true;
            }
            if (this.compareShapes(shape, DOWN_SHAPE) && Boolean.TRUE.equals(state.func_177229_b((Property)DOWN))) {
                return true;
            }
            if (this.compareShapes(shape, UP_SHAPE) && Boolean.TRUE.equals(state.func_177229_b((Property)UP))) {
                return true;
            }
            if (this.compareShapes(shape, NORTH_SHAPE) && Boolean.TRUE.equals(state.func_177229_b((Property)NORTH))) {
                return true;
            }
            if (this.compareShapes(shape, SOUTH_SHAPE) && Boolean.TRUE.equals(state.func_177229_b((Property)SOUTH))) {
                return true;
            }
            if (this.compareShapes(shape, WEST_SHAPE) && Boolean.TRUE.equals(state.func_177229_b((Property)WEST))) {
                return true;
            }
            if (this.compareShapes(shape, EAST_SHAPE) && Boolean.TRUE.equals(state.func_177229_b((Property)EAST))) {
                return true;
            }
        }
        return false;
    }

    private VoxelShape getCurentShape(BlockState state) {
        VoxelShape result = VoxelShapes.func_197880_a();
        for (VoxelShape shape : SHAPES) {
            if (!this.isRendered(shape, state)) continue;
            result = VoxelShapes.func_197872_a((VoxelShape)result, (VoxelShape)shape);
        }
        return result;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)DistExecutor.unsafeRunForDist(() -> () -> this.getShape(state, pos, this.rayTrace(worldIn, context.getEntity())), () -> () -> this.getCurentShape(state));
    }

    public VoxelShape getShape(BlockState state, BlockPos pos, RayTraceResult result) {
        if (result != null && result.func_216346_c() == RayTraceResult.Type.BLOCK && ((BlockRayTraceResult)result).func_216350_a().equals((Object)pos)) {
            Vector3d hit = result.func_216347_e();
            for (VoxelShape shape : SHAPES) {
                if (!BlockElementPipe.doesVectorColide(shape.func_197752_a().func_186670_a(pos), hit) || !this.isRendered(shape, state)) continue;
                return shape;
            }
        }
        return this.getCurentShape(state);
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getCurentShape(state);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileElementPipe pipe = (TileElementPipe)world.func_175625_s(pos);
        if (pipe != null) {
            VoxelShape shape = this.getShape(state, pos, (RayTraceResult)hit);
            Direction face = this.getFace(shape, hit);
            ActionResultType value = this.onShapeActivated(face, pipe);
            if (value != ActionResultType.PASS) {
                player.func_146105_b(pipe.getConnectionMessage(face), true);
            }
            return value;
        }
        return ActionResultType.PASS;
    }

    private ActionResultType onShapeActivated(Direction face, TileElementPipe pipe) {
        if (face != null) {
            return pipe.activatePipe(face);
        }
        return ActionResultType.PASS;
    }
}

