/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import com.google.common.collect.Lists;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.block.pipe.BlockElementPipe;
import sirttas.elementalcraft.block.tile.TileECTickable;
import sirttas.elementalcraft.block.tile.TileEntityHelper;
import sirttas.elementalcraft.config.ECConfig;

public class TileElementPipe
extends TileECTickable {
    @ObjectHolder(value="elementalcraft:elementpipe")
    public static TileEntityType<TileElementPipe> TYPE;
    private Map<Direction, ConnectionType> connections = new EnumMap<Direction, ConnectionType>(Direction.class);
    private boolean updateState = true;
    private int transferedAmount = 0;
    private int maxTransferAmount;

    public TileElementPipe() {
        this((Integer)ECConfig.COMMON.pipeTransferAmount.get());
    }

    public TileElementPipe(int maxTransferAmount) {
        super(TYPE);
        this.maxTransferAmount = maxTransferAmount;
    }

    private Optional<TileEntity> getAdjacentTile(Direction face) {
        return this.func_145830_o() ? TileEntityHelper.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(face)) : Optional.empty();
    }

    private boolean isConnectedTo(Direction face) {
        ConnectionType type = this.getConection(face);
        return type != ConnectionType.NONE && type != ConnectionType.DISCONNECT;
    }

    private boolean isExtracting(Direction face) {
        return this.getConection(face) == ConnectionType.EXTRACT;
    }

    private ConnectionType getConection(Direction face) {
        if (this.connections.containsKey(face)) {
            return this.connections.get(face);
        }
        return ConnectionType.NONE;
    }

    private void setConection(Direction face, ConnectionType type) {
        this.connections.put(face, type);
        this.forceSync();
        this.updateState = true;
    }

    private void refresh(Direction face) {
        this.setConection(face, this.getAdjacentTile(face).map(tile -> {
            ConnectionType connection = this.getConection(face);
            if (connection != ConnectionType.NONE) {
                return connection;
            }
            if (tile instanceof TileElementPipe) {
                return ConnectionType.CONNECT;
            }
            return CapabilityElementStorage.get(tile).map(storage -> {
                if (storage.canPipeInsert()) {
                    return ConnectionType.INSERT;
                }
                if (storage.canPipeExtract()) {
                    return ConnectionType.EXTRACT;
                }
                return ConnectionType.NONE;
            }).orElse(ConnectionType.NONE);
        }).orElse(ConnectionType.NONE));
    }

    public void refresh() {
        for (Direction face : Direction.values()) {
            this.refresh(face);
        }
    }

    private void transferElement(IElementStorage sender) {
        Path path;
        IElementStorage receiver;
        int amount = this.maxTransferAmount - this.transferedAmount;
        ElementType type = sender.getElementType();
        if (type != ElementType.NONE && (receiver = (path = new Path()).searchReceiver(this, type, sender.extractElement(amount, type, true))) != null) {
            int remainingAmount = path.amount - sender.transferTo(receiver, path.amount);
            path.pipes.forEach(p -> p.transferedAmount += remainingAmount);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.refresh();
        this.transferedAmount = 0;
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            this.connections.forEach((k, v) -> {
                if (v == ConnectionType.EXTRACT) {
                    this.getAdjacentTile((Direction)k).map(CapabilityElementStorage::get).orElseGet(LazyOptional::empty).ifPresent(this::transferElement);
                }
            });
        }
        if (this.updateState && this.func_145830_o()) {
            this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_145831_w().func_180495_p(this.field_174879_c).func_206870_a((Property)BlockElementPipe.NORTH, (Comparable)Boolean.valueOf(this.isConnectedTo(Direction.NORTH)))).func_206870_a((Property)BlockElementPipe.EAST, (Comparable)Boolean.valueOf(this.isConnectedTo(Direction.EAST)))).func_206870_a((Property)BlockElementPipe.SOUTH, (Comparable)Boolean.valueOf(this.isConnectedTo(Direction.SOUTH)))).func_206870_a((Property)BlockElementPipe.WEST, (Comparable)Boolean.valueOf(this.isConnectedTo(Direction.WEST)))).func_206870_a((Property)BlockElementPipe.UP, (Comparable)Boolean.valueOf(this.isConnectedTo(Direction.UP)))).func_206870_a((Property)BlockElementPipe.DOWN, (Comparable)Boolean.valueOf(this.isConnectedTo(Direction.DOWN)))).func_206870_a((Property)BlockElementPipe.NORTH_EXTRACT, (Comparable)Boolean.valueOf(this.isExtracting(Direction.NORTH)))).func_206870_a((Property)BlockElementPipe.EAST_EXTRACT, (Comparable)Boolean.valueOf(this.isExtracting(Direction.EAST)))).func_206870_a((Property)BlockElementPipe.SOUTH_EXTRACT, (Comparable)Boolean.valueOf(this.isExtracting(Direction.SOUTH)))).func_206870_a((Property)BlockElementPipe.WEST_EXTRACT, (Comparable)Boolean.valueOf(this.isExtracting(Direction.WEST)))).func_206870_a((Property)BlockElementPipe.UP_EXTRACT, (Comparable)Boolean.valueOf(this.isExtracting(Direction.UP)))).func_206870_a((Property)BlockElementPipe.DOWN_EXTRACT, (Comparable)Boolean.valueOf(this.isExtracting(Direction.DOWN))));
            this.updateState = false;
        }
    }

    public ActionResultType activatePipe(Direction face) {
        return this.getAdjacentTile(face).map(tile -> {
            ConnectionType connection = this.getConection(face);
            switch (connection) {
                case INSERT: {
                    if (CapabilityElementStorage.get(tile).filter(IElementStorage::canPipeExtract).isPresent()) {
                        this.setConection(face, ConnectionType.EXTRACT);
                    } else {
                        this.setConection(face, ConnectionType.DISCONNECT);
                    }
                    return ActionResultType.SUCCESS;
                }
                case EXTRACT: 
                case CONNECT: {
                    this.setConection(face, ConnectionType.DISCONNECT);
                    if (tile instanceof TileElementPipe) {
                        ((TileElementPipe)tile).setConection(face.func_176734_d(), ConnectionType.DISCONNECT);
                    }
                    return ActionResultType.SUCCESS;
                }
                case DISCONNECT: {
                    LazyOptional<IElementStorage> cap = CapabilityElementStorage.get(tile);
                    if (cap.filter(IElementStorage::canPipeInsert).isPresent()) {
                        this.setConection(face, ConnectionType.INSERT);
                    } else if (cap.filter(IElementStorage::canPipeExtract).isPresent()) {
                        this.setConection(face, ConnectionType.EXTRACT);
                    } else if (tile instanceof TileElementPipe) {
                        this.setConection(face, ConnectionType.CONNECT);
                        ((TileElementPipe)tile).setConection(face.func_176734_d(), ConnectionType.CONNECT);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
            return ActionResultType.PASS;
        }).orElse(ActionResultType.PASS);
    }

    public ITextComponent getConnectionMessage(Direction face) {
        return this.getConection(face).getDisplayName();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        for (Direction face : Direction.values()) {
            this.setConection(face, ConnectionType.fromInteger(compound.func_74762_e(face.func_176610_l())));
        }
        this.maxTransferAmount = compound.func_74762_e("max_transfer_amount");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.connections.forEach((k, v) -> compound.func_74768_a(k.func_176610_l(), v.getValue()));
        compound.func_74768_a("max_transfer_amount", this.maxTransferAmount);
        return compound;
    }

    private static class Path {
        List<TileElementPipe> visited = Lists.newArrayListWithCapacity((int)100);
        List<TileElementPipe> pipes = Lists.newArrayListWithCapacity((int)100);
        int amount;

        private Path() {
        }

        private IElementStorage searchReceiver(TileElementPipe pipe, ElementType type, int lastCount) {
            int count = Math.min(lastCount, pipe.maxTransferAmount - pipe.transferedAmount);
            if (count > 0 && !this.visited.contains(pipe)) {
                this.visited.add(pipe);
                return pipe.connections.entrySet().stream().map(connection -> pipe.getAdjacentTile((Direction)connection.getKey()).map(entity -> {
                    LazyOptional<IElementStorage> cap;
                    if (entity instanceof TileElementPipe && connection.getValue() == ConnectionType.CONNECT) {
                        IElementStorage ret = this.searchReceiver((TileElementPipe)entity, type, count);
                        if (ret != null) {
                            this.pipes.add(pipe);
                            return ret;
                        }
                    } else if (entity != null && connection.getValue() == ConnectionType.INSERT && (cap = CapabilityElementStorage.get(entity)).filter(receiver -> receiver.canPipeInsert() && receiver.insertElement(count, type, true) < count).isPresent()) {
                        this.amount = count;
                        this.pipes.add(pipe);
                        return (IElementStorage)cap.orElse(null);
                    }
                    return null;
                })).filter(Optional::isPresent).map(Optional::get).findAny().orElse(null);
            }
            return null;
        }
    }

    private static enum ConnectionType {
        NONE(0, "none"),
        CONNECT(1, "connect"),
        INSERT(2, "insert"),
        EXTRACT(3, "extract"),
        DISCONNECT(4, "disconnect");

        private final int value;
        private final String translationKey;

        private ConnectionType(int value, String key) {
            this.value = value;
            this.translationKey = "message.elementalcraft." + key;
        }

        public int getValue() {
            return this.value;
        }

        public static ConnectionType fromInteger(int x) {
            for (ConnectionType type : ConnectionType.values()) {
                if (type.getValue() != x) continue;
                return type;
            }
            return NONE;
        }

        public ITextComponent getDisplayName() {
            return new TranslationTextComponent(this.translationKey);
        }
    }
}

