/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser.pedestal;

import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.block.pureinfuser.TilePureInfuser;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalElementStorage;
import sirttas.elementalcraft.block.tile.TileECContainer;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.inventory.SingleItemInventory;
import sirttas.elementalcraft.rune.handler.CapabilityRuneHandler;
import sirttas.elementalcraft.rune.handler.RuneHandler;

public class TilePedestal
extends TileECContainer
implements IElementTypeProvider {
    @ObjectHolder(value="elementalcraft:pedestal")
    public static TileEntityType<TilePedestal> TYPE;
    private final SingleItemInventory inventory = new SingleItemInventory(this::forceSync);
    private final IElementStorage elementStorage;
    private final RuneHandler runeHandler;

    public TilePedestal() {
        this(ElementType.NONE);
    }

    public TilePedestal(ElementType type) {
        super(TYPE);
        this.elementStorage = new PedestalElementStorage(type, this::forceSync);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.pedestalMaxRunes.get());
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("element_storage")) {
            CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY.readNBT((Object)this.elementStorage, null, compound.func_74781_a("element_storage"));
        } else {
            CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY.readNBT((Object)this.elementStorage, null, (INBT)compound);
        }
        if (compound.func_74764_b("rune_handler")) {
            CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY.readNBT((Object)this.runeHandler, null, compound.func_74781_a("rune_handler"));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("element_storage", CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY.writeNBT((Object)this.elementStorage, null));
        compound.func_218657_a("rune_handler", CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY.writeNBT((Object)this.runeHandler, null));
        return compound;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(Capability<U> cap, @Nullable Direction side) {
        if (!this.field_145846_f) {
            if (cap == CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY) {
                return LazyOptional.of((NonNullSupplier)(this.elementStorage != null ? () -> this.elementStorage : null)).cast();
            }
            if (cap == CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY) {
                return LazyOptional.of((NonNullSupplier)(this.runeHandler != null ? () -> this.runeHandler : null)).cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public Direction getPureInfuserDirection() {
        return Stream.of(Direction.values()).filter(d -> d.func_176740_k().func_176716_d() == Direction.Plane.HORIZONTAL).filter(d -> this.func_145831_w().func_175625_s(this.field_174879_c.func_177967_a(d, 3)) instanceof TilePureInfuser).findAny().orElse(Direction.UP);
    }

    @Override
    public ElementType getElementType() {
        return this.elementStorage.getElementType();
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    public ItemStack getItem() {
        return this.inventory.func_70301_a(0);
    }

    public IElementStorage getElementStorage() {
        return this.elementStorage;
    }

    @Nonnull
    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }
}

