/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.retriever;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import sirttas.elementalcraft.block.BlockEC;
import sirttas.elementalcraft.inventory.ECInventoryHelper;

public class BlockRetriever
extends BlockEC {
    public static final String NAME = "instrument_retriever";
    private static final VoxelShape CORE = Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape SOURCE_NORTH = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)2.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)10.0, (double)5.0));
    private static final VoxelShape SOURCE_SOUTH = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)11.0, (double)10.0, (double)10.0, (double)14.0));
    private static final VoxelShape SOURCE_WEST = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)2.0, (double)6.0, (double)6.0, (double)5.0, (double)10.0, (double)10.0));
    private static final VoxelShape SOURCE_EAST = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)14.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)11.0, (double)6.0, (double)6.0, (double)14.0, (double)10.0, (double)10.0));
    private static final VoxelShape SOURCE_DOWN = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0));
    private static final VoxelShape TARGET_NORTH = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)3.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)3.0, (double)10.0, (double)10.0, (double)5.0));
    private static final VoxelShape TARGET_SOUTH = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)7.0, (double)13.0, (double)9.0, (double)9.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)11.0, (double)10.0, (double)10.0, (double)13.0));
    private static final VoxelShape TARGET_WEST = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)3.0, (double)9.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)3.0, (double)6.0, (double)6.0, (double)5.0, (double)10.0, (double)10.0));
    private static final VoxelShape TARGET_EAST = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)13.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)11.0, (double)6.0, (double)6.0, (double)13.0, (double)10.0, (double)10.0));
    private static final VoxelShape TARGET_DOWN = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)3.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0));
    private static final VoxelShape TARGET_UP = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0));
    private static final List<VoxelShape> SOURCE_SHAPES = ImmutableList.of((Object)SOURCE_NORTH, (Object)SOURCE_SOUTH, (Object)SOURCE_WEST, (Object)SOURCE_EAST, (Object)SOURCE_DOWN);
    private static final List<VoxelShape> TARGET_SHAPES = ImmutableList.of((Object)TARGET_NORTH, (Object)TARGET_SOUTH, (Object)TARGET_WEST, (Object)TARGET_EAST, (Object)TARGET_DOWN, (Object)TARGET_UP);
    public static final DirectionProperty SOURCE = DirectionProperty.func_177712_a((String)"source", d -> d != Direction.UP);
    public static final DirectionProperty TARGET = DirectionProperty.func_196962_a((String)"target", (Direction[])Direction.values());

    public BlockRetriever() {
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)SOURCE, (Comparable)Direction.SOUTH)).func_206870_a((Property)TARGET, (Comparable)Direction.NORTH));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)SOURCE, (Comparable)(direction.func_176740_k() == Direction.Axis.Y ? Direction.DOWN : direction.func_176734_d()))).func_206870_a((Property)TARGET, (Comparable)direction);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{SOURCE, TARGET});
    }

    private VoxelShape getSourceShape(BlockState state) {
        switch ((Direction)state.func_177229_b((Property)SOURCE)) {
            case EAST: {
                return SOURCE_EAST;
            }
            case NORTH: {
                return SOURCE_NORTH;
            }
            case SOUTH: {
                return SOURCE_SOUTH;
            }
            case WEST: {
                return SOURCE_WEST;
            }
        }
        return SOURCE_DOWN;
    }

    private VoxelShape getTargetShape(BlockState state) {
        switch ((Direction)state.func_177229_b((Property)TARGET)) {
            case EAST: {
                return TARGET_EAST;
            }
            case NORTH: {
                return TARGET_NORTH;
            }
            case SOUTH: {
                return TARGET_SOUTH;
            }
            case WEST: {
                return TARGET_WEST;
            }
            case DOWN: {
                return TARGET_DOWN;
            }
        }
        return TARGET_UP;
    }

    private VoxelShape getCurentShape(BlockState state) {
        return VoxelShapes.func_216384_a((VoxelShape)this.getSourceShape(state), (VoxelShape[])new VoxelShape[]{this.getTargetShape(state), CORE}).func_197753_c();
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)DistExecutor.unsafeRunForDist(() -> () -> this.getShape(state, pos, this.rayTrace(worldIn, context.getEntity())), () -> () -> this.getCurentShape(state));
    }

    public VoxelShape getShape(BlockState state, BlockPos pos, RayTraceResult result) {
        if (result != null && result.func_216346_c() == RayTraceResult.Type.BLOCK && ((BlockRayTraceResult)result).func_216350_a().equals((Object)pos)) {
            Vector3d hit = result.func_216347_e();
            VoxelShape source = this.getSourceShape(state);
            VoxelShape target = this.getTargetShape(state);
            if (BlockRetriever.doesVectorColide(source.func_197752_a().func_186670_a(pos), hit)) {
                return source;
            }
            if (BlockRetriever.doesVectorColide(target.func_197752_a().func_186670_a(pos), hit)) {
                return target;
            }
            if (BlockRetriever.doesVectorColide(CORE.func_197752_a().func_186670_a(pos), hit)) {
                return CORE;
            }
        }
        return this.getCurentShape(state);
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getCurentShape(state);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        VoxelShape shape = this.getShape(state, pos, (RayTraceResult)hit);
        Direction direction = hit.func_216354_b().func_176734_d();
        if (state.func_177229_b((Property)SOURCE) == direction || state.func_177229_b((Property)TARGET) == direction) {
            return ActionResultType.PASS;
        }
        if (SOURCE_SHAPES.contains(shape)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)SOURCE, (Comparable)(direction.func_176740_k() == Direction.Axis.Y ? Direction.DOWN : direction)));
            return ActionResultType.SUCCESS;
        }
        if (TARGET_SHAPES.contains(shape)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)TARGET, (Comparable)direction));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static void sendOutputToRetriever(World world, BlockPos pos, IInventory inventory, int slot) {
        for (Direction direction : Direction.values()) {
            BlockPos retriverPos = pos.func_177972_a(direction);
            BlockState blockState = world.func_180495_p(retriverPos);
            if (!(blockState.func_177230_c() instanceof BlockRetriever) || blockState.func_177229_b((Property)SOURCE) != direction.func_176734_d()) continue;
            ItemStack output = BlockRetriever.retrive(blockState, (IBlockReader)world, retriverPos, inventory.func_70301_a(slot));
            inventory.func_70299_a(slot, output);
            if (!output.func_190926_b()) continue;
            return;
        }
    }

    public static ItemStack retrive(BlockState state, IBlockReader world, BlockPos pos, ItemStack output) {
        Direction direction = (Direction)state.func_177229_b((Property)TARGET);
        return ItemHandlerHelper.insertItem((IItemHandler)ECInventoryHelper.getItemHandlerAt(world, pos.func_177972_a(direction), direction.func_176734_d()), (ItemStack)output, (boolean)false);
    }
}

