/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.block.shrine.ShrineElementStorage;
import sirttas.elementalcraft.block.shrine.upgrade.BlockShrineUpgrade;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrade;
import sirttas.elementalcraft.block.tile.TileECTickable;
import sirttas.elementalcraft.config.ECConfig;

public abstract class TileShrine
extends TileECTickable {
    protected static final List<Direction> DEFAULT_UPGRRADE_DIRECTIONS = ImmutableList.of((Object)Direction.UP, (Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.WEST, (Object)Direction.EAST);
    private final double basePeriode;
    private final int baseElementCapacity;
    private final float baseRange;
    private final int baseConsumeAmount;
    private final Map<Direction, ShrineUpgrade> upgrades = new EnumMap<Direction, ShrineUpgrade>(Direction.class);
    private final Map<ShrineUpgrade.BonusType, Float> upgradeMultipliers = new EnumMap<ShrineUpgrade.BonusType, Float>(ShrineUpgrade.BonusType.class);
    protected final ShrineElementStorage elementStorage;
    private boolean running = false;
    private double tick = 0.0;
    private int rangeRenderTimer = 0;

    public TileShrine(TileEntityType<?> tileEntityTypeIn, Properties properties) {
        super(tileEntityTypeIn);
        this.basePeriode = properties.periode;
        this.baseElementCapacity = properties.capacity;
        this.baseRange = properties.range;
        this.baseConsumeAmount = properties.consumeAmount;
        if (this.basePeriode == 0.0) {
            throw new IllegalArgumentException("Shrine periode should not be 0");
        }
        this.elementStorage = new ShrineElementStorage(properties.elementType, properties.capacity, this::forceSync);
    }

    protected int consumeElement() {
        return this.consumeElement(this.getConsumeAmount());
    }

    protected int consumeElement(int i) {
        return this.elementStorage.extractElement(i, false);
    }

    protected abstract boolean doTick();

    @Override
    public final void func_73660_a() {
        if (this.isToSync()) {
            this.refreshUpgrades();
        }
        double periode = this.getPeriod();
        int consumeAmount = this.getConsumeAmount();
        super.func_73660_a();
        this.running = false;
        if (this.func_145830_o() && !this.isPowered()) {
            this.tick += 1.0;
            if (periode == 0.0) {
                ElementalCraft.LOGGER.warn("Shrine periode should not be 0");
                periode = 1.0;
            }
            while (this.tick >= periode) {
                if (this.elementStorage.getElementAmount() >= consumeAmount && this.doTick()) {
                    this.consumeElement();
                }
                this.tick -= periode;
            }
        }
        if (this.rangeRenderTimer > 0) {
            --this.rangeRenderTimer;
        }
    }

    public void refreshUpgrades() {
        if (this.func_145830_o()) {
            this.upgrades.clear();
            this.upgradeMultipliers.clear();
            this.getUpgradeDirections().forEach(direction -> {
                ShrineUpgrade upgrade;
                BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v().func_177972_a(direction));
                Block block = state.func_177230_c();
                if (block instanceof BlockShrineUpgrade && (upgrade = ((BlockShrineUpgrade)block).getUpgrade()) != null) {
                    this.setUpgrade((Direction)direction, upgrade);
                }
            });
        }
    }

    protected float getMultiplier(ShrineUpgrade.BonusType type) {
        return this.upgradeMultipliers.getOrDefault((Object)type, Float.valueOf(1.0f)).floatValue();
    }

    public int getUpgradeCount(ShrineUpgrade upgrade) {
        return upgrade == null ? 0 : (int)this.upgrades.values().stream().filter(upgrade::equals).count();
    }

    public boolean hasUpgrade(ShrineUpgrade upgrade) {
        return this.getUpgradeCount(upgrade) > 0;
    }

    public void setUpgrade(Direction direction, ShrineUpgrade upgrade) {
        ShrineUpgrade old = this.upgrades.get(direction);
        if (old != null) {
            old.getBonuses().forEach((type, bonus) -> this.upgradeMultipliers.put((ShrineUpgrade.BonusType)((Object)type), Float.valueOf(this.getMultiplier((ShrineUpgrade.BonusType)((Object)type)) / bonus.floatValue())));
        }
        this.upgrades.put(direction, upgrade);
        upgrade.getBonuses().forEach((type, bonus) -> this.upgradeMultipliers.put((ShrineUpgrade.BonusType)((Object)type), Float.valueOf(this.getMultiplier((ShrineUpgrade.BonusType)((Object)type)) * bonus.floatValue())));
        this.elementStorage.setCapacity((int)((float)this.baseElementCapacity * this.getMultiplier(ShrineUpgrade.BonusType.CAPACITY)));
    }

    public Collection<ShrineUpgrade> getAllUpgrades() {
        return this.upgrades.values();
    }

    public List<Direction> getUpgradeDirections() {
        return DEFAULT_UPGRRADE_DIRECTIONS;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean showsRange() {
        return this.rangeRenderTimer > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startShowingRange() {
        this.rangeRenderTimer = 600;
    }

    public AxisAlignedBB getRangeBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g((double)this.getRange());
    }

    public float getRange() {
        return this.baseRange * this.getMultiplier(ShrineUpgrade.BonusType.RANGE);
    }

    public int getIntegerRange() {
        return Math.round(this.getRange());
    }

    public int getConsumeAmount() {
        return Math.round((float)this.baseConsumeAmount * this.getMultiplier(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION));
    }

    public double getPeriod() {
        return this.basePeriode * (double)this.getMultiplier(ShrineUpgrade.BonusType.SPEED);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("element_storage")) {
            CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY.readNBT((Object)this.elementStorage, null, compound.func_74781_a("element_storage"));
        } else {
            CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY.readNBT((Object)this.elementStorage, null, (INBT)compound);
        }
        this.running = compound.func_74767_n("running");
        this.refreshUpgrades();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("element_storage", CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY.writeNBT((Object)this.elementStorage, null));
        compound.func_74757_a("running", this.running);
        return compound;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(Capability<U> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY) {
            return LazyOptional.of((NonNullSupplier)(this.elementStorage != null ? () -> this.elementStorage : null)).cast();
        }
        return super.getCapability(cap, side);
    }

    public IElementStorage getElementStorage() {
        return this.elementStorage;
    }

    public static final class Properties {
        private double periode;
        private int consumeAmount;
        private int capacity;
        private float range;
        private ElementType elementType;

        private Properties(ElementType elementType) {
            this.elementType = elementType;
            this.consumeAmount = 0;
            this.periode = 1.0;
            this.range = 1.0f;
            this.capacity = (Integer)ECConfig.COMMON.shrinesCapacity.get();
        }

        public static Properties create(ElementType elementType) {
            return new Properties(elementType);
        }

        public Properties consumeAmount(int consumeAmount) {
            this.consumeAmount = consumeAmount;
            return this;
        }

        public Properties periode(double periode) {
            this.periode = periode;
            return this;
        }

        public Properties capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public Properties range(float range) {
            this.range = range;
            return this;
        }
    }
}

