/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.breeding;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shrine.TileShrine;
import sirttas.elementalcraft.block.shrine.breeding.BlockBreedingShrine;
import sirttas.elementalcraft.config.ECConfig;

public class TileBreedingShrine
extends TileShrine {
    @ObjectHolder(value="elementalcraft:breedingshrine")
    public static TileEntityType<TileBreedingShrine> TYPE;
    private static final TileShrine.Properties PROPERTIES;

    public TileBreedingShrine() {
        super(TYPE, PROPERTIES);
    }

    private <T extends Entity> List<T> getEntities(Class<T> clazz) {
        return this.func_145831_w().func_175647_a(clazz, this.getRangeBoundingBox(), e -> !e.func_175149_v()).stream().collect(Collectors.toList());
    }

    @Override
    public AxisAlignedBB getRangeBoundingBox() {
        return super.getRangeBoundingBox().func_191194_a(Vector3d.func_237491_b_((Vector3i)((Direction)this.func_195044_w().func_177229_b((Property)BlockBreedingShrine.FACING)).func_176730_m()).func_186678_a((double)this.getRange()));
    }

    @Override
    protected boolean doTick() {
        EntityType type = null;
        AnimalEntity first = null;
        AnimalEntity second = null;
        for (AnimalEntity entity : this.getEntities(AnimalEntity.class)) {
            if (type == null && entity.func_204701_dC()) {
                type = entity.func_200600_R();
                first = entity;
                continue;
            }
            if (second != null || type == null || !type.equals(entity.func_200600_R()) || !entity.func_204701_dC()) continue;
            second = entity;
        }
        if (first != null && second != null) {
            return this.feed(first, second);
        }
        return false;
    }

    public boolean feed(AnimalEntity first, AnimalEntity second) {
        List foodList = this.getEntities(ItemEntity.class).stream().map(ItemEntity::func_92059_d).filter(stack -> first.func_70877_b(stack) && stack.func_190916_E() > 0).collect(Collectors.toList());
        if (!foodList.isEmpty()) {
            if (((ItemStack)foodList.get(0)).func_190916_E() >= 2) {
                ((ItemStack)foodList.get(0)).func_190918_g(2);
            } else if (foodList.size() >= 2) {
                ((ItemStack)foodList.get(0)).func_190918_g(1);
                ((ItemStack)foodList.get(1)).func_190918_g(1);
            } else {
                return false;
            }
            first.func_204700_e(600);
            second.func_204700_e(600);
            return true;
        }
        return false;
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        BlockState state = this.func_195044_w();
        return state.func_177229_b(BlockBreedingShrine.PART) == BlockBreedingShrine.Part.BOWL ? Collections.emptyList() : DEFAULT_UPGRRADE_DIRECTIONS.stream().filter(direction -> direction != state.func_177229_b((Property)BlockBreedingShrine.FACING)).collect(Collectors.toList());
    }

    static {
        PROPERTIES = TileShrine.Properties.create(ElementType.EARTH).periode((Double)ECConfig.COMMON.breedingShrinePeriode.get()).consumeAmount((Integer)ECConfig.COMMON.breedingShrineConsumeAmount.get()).range(((Integer)ECConfig.COMMON.breedingShrineRange.get()).intValue());
    }
}

