/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.growth;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shrine.TileShrine;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.config.ECConfig;

public class TileGrowthShrine
extends TileShrine {
    @ObjectHolder(value="elementalcraft:growthshrine")
    public static TileEntityType<TileGrowthShrine> TYPE;
    private static final TileShrine.Properties PROPERTIES;

    public TileGrowthShrine() {
        super(TYPE, PROPERTIES);
    }

    private Optional<BlockPos> findGrowable() {
        int range = this.getIntegerRange();
        List positions = IntStream.range(-range, range + 1).mapToObj(x -> IntStream.range(-range, range + 1).mapToObj(z -> IntStream.range(0, 4).mapToObj(y -> new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z)))).flatMap(s -> s.flatMap(s2 -> s2)).filter(this::canGrow).collect(Collectors.toList());
        return positions.isEmpty() ? Optional.empty() : Optional.of((BlockPos)positions.get(this.field_145850_b.field_73012_v.nextInt(positions.size())));
    }

    private boolean canGrow(BlockPos pos) {
        BlockState blockstate = this.field_145850_b.func_180495_p(pos);
        Block block = blockstate.func_177230_c();
        if (block instanceof IGrowable) {
            IGrowable igrowable = (IGrowable)block;
            return igrowable.func_176473_a((IBlockReader)this.field_145850_b, pos, blockstate, this.field_145850_b.field_72995_K) && (igrowable.func_180670_a(this.field_145850_b, this.field_145850_b.field_73012_v, pos, blockstate) || this.hasUpgrade(ShrineUpgrades.bonelessGrowth));
        }
        return false;
    }

    @Override
    public AxisAlignedBB getRangeBoundingBox() {
        int range = this.getIntegerRange();
        return new AxisAlignedBB(this.func_174877_v()).func_72314_b((double)range, 0.0, (double)range).func_72321_a(0.0, 2.0, 0.0);
    }

    @Override
    protected boolean doTick() {
        if (this.field_145850_b instanceof ServerWorld) {
            return this.findGrowable().map(p -> {
                BlockState blockstate = this.field_145850_b.func_180495_p(p);
                ((IGrowable)blockstate.func_177230_c()).func_225535_a_((ServerWorld)this.field_145850_b, this.field_145850_b.field_73012_v, p, blockstate);
                this.field_145850_b.func_217379_c(2005, p, 0);
                return true;
            }).orElse(false);
        }
        return false;
    }

    static {
        PROPERTIES = TileShrine.Properties.create(ElementType.WATER).periode((Double)ECConfig.COMMON.growthShrinePeriode.get()).consumeAmount((Integer)ECConfig.COMMON.growthShrineConsumeAmount.get()).range(((Integer)ECConfig.COMMON.growthShrineRange.get()).intValue());
    }
}

