/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.lava;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.block.Blocks;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shrine.TileShrine;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.tag.ECTags;

public class TileLavaShrine
extends TileShrine {
    @ObjectHolder(value="elementalcraft:lavashrine")
    public static TileEntityType<TileLavaShrine> TYPE;
    private static final TileShrine.Properties PROPERTIES;
    protected static final List<Direction> UPGRRADE_DIRECTIONS;

    public TileLavaShrine() {
        super(TYPE, PROPERTIES);
    }

    private Optional<BlockPos> findRock() {
        int range = (Integer)ECConfig.COMMON.lavaShrineRange.get();
        return IntStream.range(-range, range + 1).mapToObj(x -> IntStream.range(-range, range + 1).mapToObj(z -> new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + z))).flatMap(s -> s).filter(p -> ECTags.Blocks.LAVASHRINE_LIQUIFIABLES.func_230235_a_((Object)this.field_145850_b.func_180495_p(p).func_177230_c())).findAny();
    }

    @Override
    public AxisAlignedBB getRangeBoundingBox() {
        int range = (Integer)ECConfig.COMMON.lavaShrineRange.get();
        return new AxisAlignedBB(this.func_174877_v()).func_72314_b((double)range, 0.0, (double)range).func_72317_d(0.0, 1.0, 0.0);
    }

    @Override
    protected boolean doTick() {
        return this.findRock().map(p -> {
            this.field_145850_b.func_175656_a(p, Blocks.field_150353_l.func_176223_P());
            this.field_145850_b.func_217379_c(1501, p, 0);
            return true;
        }).orElse(false);
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        return UPGRRADE_DIRECTIONS;
    }

    static {
        PROPERTIES = TileShrine.Properties.create(ElementType.FIRE).periode((Double)ECConfig.COMMON.lavaShrinePeriode.get()).consumeAmount((Integer)ECConfig.COMMON.lavaShrineConsumeAmount.get()).range(((Integer)ECConfig.COMMON.lavaShrineRange.get()).intValue()).capacity((Integer)ECConfig.COMMON.shrinesCapacity.get() * 10);
        UPGRRADE_DIRECTIONS = ImmutableList.of((Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.WEST, (Object)Direction.EAST);
    }
}

