/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.tags.ITag;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import sirttas.dpanvil.api.codec.CodecHelper;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicates;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.dpanvil.api.predicate.block.logical.OrBlockPredicate;
import sirttas.elementalcraft.block.shrine.TileShrine;
import sirttas.elementalcraft.data.predicate.block.shrine.HasShrineUpgradePredicate;
import sirttas.elementalcraft.upgrade.AbstractUpgrade;

public class ShrineUpgrade
extends AbstractUpgrade<BonusType> {
    public static final Codec<ShrineUpgrade> CODEC = RecordCodecBuilder.create(builder -> AbstractUpgrade.codec(builder, BonusType.CODEC).apply((Applicative)builder, ShrineUpgrade::new));

    private ShrineUpgrade(IBlockPosPredicate predicate, Map<BonusType, Float> bonuses, int maxAmount) {
        super(predicate, new EnumMap<BonusType, Float>(bonuses), maxAmount);
    }

    boolean canUpgrade(TileShrine shrine) {
        return this.canUpgrade((IWorldReader)shrine.func_145831_w(), shrine.func_174877_v(), shrine.getUpgradeCount(this));
    }

    public void addInformation(List<ITextComponent> tooltip) {
        this.bonuses.forEach((type, multiplier) -> tooltip.add((ITextComponent)new TranslationTextComponent("shrine_upgrade_bonus.elementalcraft." + type.func_176610_l(), new Object[]{this.formatMultiplier((Float)multiplier)}).func_240699_a_(type.isPositive() ^ multiplier.floatValue() < 1.0f ? TextFormatting.BLUE : TextFormatting.RED)));
        if (this.maxAmount > 0) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.elementalcraft.max_amount", new Object[]{this.maxAmount}).func_240699_a_(TextFormatting.YELLOW));
        }
    }

    private String formatMultiplier(Float multiplier) {
        if (multiplier.floatValue() >= 10.0f) {
            return new DecimalFormat("\u00d7#.##").format(multiplier);
        }
        return String.format("%+d%%", Math.round((multiplier.floatValue() - 1.0f) * 100.0f));
    }

    public static class Builder {
        public static final Codec<Builder> CODEC = CODEC.xmap(shrineUpgrade -> {
            Builder builder = Builder.create().predicate(((ShrineUpgrade)shrineUpgrade).predicate).max(((ShrineUpgrade)shrineUpgrade).maxAmount);
            ((ShrineUpgrade)shrineUpgrade).bonuses.forEach(builder::addBonus);
            return builder;
        }, builder -> new ShrineUpgrade(builder.predicate, builder.bonuses, builder.maxAmount));
        private IBlockPosPredicate predicate = null;
        private final Map<BonusType, Float> bonuses = new EnumMap<BonusType, Float>(BonusType.class);
        private int maxAmount = 0;
        private Set<ResourceLocation> incompatibilities = Sets.newHashSet();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder match(Block ... block) {
            return this.predicate(BlockPosPredicates.match((Block[])block));
        }

        public Builder match(ITag.INamedTag<Block> tag) {
            return this.predicate(BlockPosPredicates.match(tag));
        }

        public Builder predicate(IBlockPosPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder max(int max) {
            this.maxAmount = max;
            return this;
        }

        public Builder incompatibleWith(ResourceLocation ... locs) {
            Collections.addAll(this.incompatibilities, locs);
            return this;
        }

        public Builder addBonus(BonusType type, float value) {
            this.bonuses.put(type, Float.valueOf(value));
            return this;
        }

        public JsonElement toJson() {
            if (!this.incompatibilities.isEmpty()) {
                this.predicate = this.predicate.and(new IBlockPosPredicate[]{this.getIncompatibilitiesPredicate()});
            }
            return CodecHelper.encode(CODEC, (Object)this);
        }

        private IBlockPosPredicate getIncompatibilitiesPredicate() {
            return (this.incompatibilities.size() == 1 ? new HasShrineUpgradePredicate((ResourceLocation)Iterables.getOnlyElement(this.incompatibilities)) : new OrBlockPredicate((Iterable)this.incompatibilities.stream().map(HasShrineUpgradePredicate::new).collect(Collectors.toList()))).not();
        }
    }

    public static enum BonusType implements IStringSerializable
    {
        NONE("none", false),
        SPEED("speed", false),
        ELEMENT_CONSUMPTION("element_consumption", false),
        CAPACITY("capacity", true),
        RANGE("range", true),
        STRENGTH("strength", true);

        public static final Codec<BonusType> CODEC;
        private final String name;
        private final boolean positive;

        private BonusType(String name, boolean positive) {
            this.name = name;
            this.positive = positive;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public boolean isPositive() {
            return this.positive;
        }

        public static BonusType byName(String name) {
            for (BonusType bonusType : BonusType.values()) {
                if (!bonusType.name.equals(name)) continue;
                return bonusType;
            }
            return NONE;
        }

        static {
            CODEC = IStringSerializable.func_233023_a_(BonusType::values, BonusType::byName);
        }
    }
}

