/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.tank;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.block.BlockECTileProvider;
import sirttas.elementalcraft.block.tank.IElementContainer;
import sirttas.elementalcraft.block.tile.TileEntityHelper;
import sirttas.elementalcraft.particle.ParticleHelper;

public abstract class AbstractBlockTank
extends BlockECTileProvider {
    public AbstractBlockTank() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_226896_b_());
    }

    @Deprecated
    public boolean func_149740_M(BlockState state) {
        return true;
    }

    @Deprecated
    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        return this.getElementStorage(world, pos).map(tank -> tank.getElementAmount() * 15 / tank.getElementCapacity()).orElse(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World world, BlockPos pos, Random rand) {
        this.getElementStorage(world, pos).filter(t -> !t.isEmpty()).ifPresent(t -> ParticleHelper.createSourceParticle(t.getElementType(), world, Vector3d.func_237489_a_((Vector3i)pos).func_72441_c(0.0, 0.2, 0.0), rand));
    }

    private Optional<IElementStorage> getElementStorage(World world, BlockPos pos) {
        return TileEntityHelper.getTileEntityAs((IBlockReader)world, pos, IElementContainer.class).map(IElementContainer::getElementStorage);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT blockNbt;
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("BlockEntityTag") && (blockNbt = tag.func_74775_l("BlockEntityTag")) != null && blockNbt.func_74764_b("element_storage")) {
            CompoundNBT elementStorageNbt = blockNbt.func_74775_l("element_storage");
            ElementType elementType = ElementType.byName(elementStorageNbt.func_74779_i("element_type"));
            int amount = elementStorageNbt.func_74762_e("element_amount");
            int capacity = elementStorageNbt.func_74762_e("element_capacity");
            if (elementType != ElementType.NONE && amount > 0 && capacity > 0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.elementalcraft.contains", new Object[]{elementType.getDisplayName()}).func_240699_a_(TextFormatting.GREEN));
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.elementalcraft.percent_full", new Object[]{ItemStack.field_111284_a.format(amount * 100 / capacity)}).func_240699_a_(TextFormatting.GREEN));
            }
        }
    }
}

