/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.tile;

import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntityType;
import sirttas.elementalcraft.block.retriever.BlockRetriever;
import sirttas.elementalcraft.block.tile.ICraftingTile;
import sirttas.elementalcraft.block.tile.TileECContainer;
import sirttas.elementalcraft.inventory.InventoryTileWrapper;
import sirttas.elementalcraft.recipe.IInventoryTileRecipe;

public abstract class TileECCrafting<T extends ICraftingTile, R extends IInventoryTileRecipe<T>>
extends TileECContainer
implements ICraftingTile {
    protected final IRecipeType<R> recipeType;
    protected final int transferSpeed;
    protected R recipe;
    private int outputSlot = 0;

    public TileECCrafting(TileEntityType<?> tileEntityTypeIn, IRecipeType<R> recipeType, int transferSpeed) {
        super(tileEntityTypeIn);
        this.recipeType = recipeType;
        this.transferSpeed = transferSpeed;
    }

    @Override
    public boolean isRecipeAvailable() {
        if (this.recipe != null && this.recipe.matches(this.cast())) {
            return true;
        }
        this.recipe = this.lookupRecipe();
        if (this.recipe != null) {
            this.forceSync();
            return true;
        }
        return false;
    }

    @Override
    public void process() {
        if (!this.field_145850_b.field_72995_K) {
            this.recipe.process(this.cast());
            BlockRetriever.sendOutputToRetriever(this.field_145850_b, this.field_174879_c, this.getInventory(), this.outputSlot);
        }
        this.recipe = null;
        this.forceSync();
    }

    protected R lookupRecipe() {
        return (R)((IInventoryTileRecipe)this.func_145831_w().func_199532_z().func_215371_a(this.recipeType, InventoryTileWrapper.from(this.cast()), this.func_145831_w()).orElse(null));
    }

    @Override
    public void func_174888_l() {
        super.func_174888_l();
        this.recipe = null;
    }

    protected void setOutputSlot(int slot) {
        this.outputSlot = slot;
    }

    private T cast() {
        return (T)this;
    }
}

