/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data.predicate.block.rune;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.data.predicate.block.rune.IRunePredicate;
import sirttas.elementalcraft.rune.Rune;
import sirttas.elementalcraft.rune.handler.IRuneHandler;

public class HasRunePredicate
implements IRunePredicate {
    public static final String NAME = "has_rune";
    @ObjectHolder(value="elementalcraft:has_rune")
    public static BlockPosPredicateType<HasRunePredicate> TYPE;
    public static final Codec<HasRunePredicate> CODEC;
    private final int count;
    private final ResourceLocation runeId;
    private Rune rune;

    public HasRunePredicate(Rune upgrade) {
        this(upgrade, 1);
    }

    public HasRunePredicate(Rune upgrade, int count) {
        this(upgrade.getId(), count);
        this.rune = upgrade;
    }

    public HasRunePredicate(ResourceLocation runeId) {
        this(runeId, 1);
    }

    public HasRunePredicate(ResourceLocation runeId, int count) {
        this.runeId = runeId;
        this.count = count;
    }

    @Override
    public boolean test(IRuneHandler handler) {
        if (this.rune == null) {
            this.rune = (Rune)ElementalCraft.RUNE_MANAGER.get(this.runeId);
        }
        return handler.getRuneCount(this.rune) >= this.count;
    }

    public BlockPosPredicateType<HasRunePredicate> getType() {
        return TYPE;
    }

    static {
        CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.field_240908_a_.fieldOf("rune").forGetter(p -> p.runeId), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(p -> p.count)).apply((Applicative)builder, HasRunePredicate::new));
    }
}

