/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.datagen.recipe.builder.instrument;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.recipe.instrument.BindingRecipe;

public class BindingRecipeBuilder {
    private final Item result;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final ElementType elementType;
    private int elementAmount;
    private final IRecipeSerializer<?> serializer;

    public BindingRecipeBuilder(IRecipeSerializer<?> serializerIn, IItemProvider resultProviderIn, ElementType elementType) {
        this.serializer = serializerIn;
        this.result = resultProviderIn.func_199767_j();
        this.elementType = elementType;
        this.elementAmount = 2500;
    }

    public static BindingRecipeBuilder bindingRecipe(IItemProvider resultIn, ElementType elementType) {
        return new BindingRecipeBuilder(BindingRecipe.SERIALIZER, resultIn, elementType);
    }

    public BindingRecipeBuilder withElementAmount(int elementAmount) {
        this.elementAmount = elementAmount;
        return this;
    }

    public BindingRecipeBuilder addIngredient(ITag.INamedTag<Item> tagIn) {
        return this.addIngredient(Ingredient.func_199805_a(tagIn));
    }

    public BindingRecipeBuilder addIngredient(IItemProvider itemIn) {
        return this.addIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
    }

    public BindingRecipeBuilder addIngredient(Ingredient ingredientIn) {
        this.ingredients.add(ingredientIn);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        this.build(consumerIn, new ResourceLocation(id.func_110624_b(), "binding/" + id.func_110623_a()));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Binding Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, ElementalCraft.createRL("binding/" + save));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.serializer, this.ingredients, this.result, this.elementType, this.elementAmount));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final List<Ingredient> ingredients;
        private final Item output;
        private final ElementType elementType;
        private final int elementAmount;
        private final IRecipeSerializer<?> serializer;

        public Result(ResourceLocation idIn, IRecipeSerializer<?> serializerIn, List<Ingredient> ingredients, Item resultIn, ElementType elementType, int elementAmount) {
            this.id = idIn;
            this.serializer = serializerIn;
            this.ingredients = ingredients;
            this.output = resultIn;
            this.elementType = elementType;
            this.elementAmount = elementAmount;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("element_type", this.elementType.func_176610_l());
            json.addProperty("element_amount", (Number)this.elementAmount);
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.func_200304_c());
            }
            json.add("ingredients", (JsonElement)jsonarray);
            json.addProperty("output", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.output).toString());
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

