/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.datagen.recipe.builder.instrument;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.recipe.instrument.infusion.InfusionRecipe;

public class InfusionRecipeBuilder {
    private final Item result;
    private final Ingredient ingredient;
    private final ElementType elementType;
    private int elementAmount;
    private final IRecipeSerializer<?> serializer;

    public InfusionRecipeBuilder(IRecipeSerializer<?> serializerIn, Ingredient ingredientIn, IItemProvider resultProviderIn, ElementType elementType) {
        this.serializer = serializerIn;
        this.result = resultProviderIn.func_199767_j();
        this.ingredient = ingredientIn;
        this.elementType = elementType;
        this.elementAmount = 1000;
    }

    public static InfusionRecipeBuilder infusionRecipe(Ingredient ingredientIn, IItemProvider resultIn, ElementType elementType) {
        return new InfusionRecipeBuilder(InfusionRecipe.SERIALIZER, ingredientIn, resultIn, elementType);
    }

    public InfusionRecipeBuilder withElementAmount(int elementAmount) {
        this.elementAmount = elementAmount;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        this.build(consumerIn, new ResourceLocation(id.func_110624_b(), "infusion/" + id.func_110623_a()));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Infusion Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, ElementalCraft.createRL("binding/" + save));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.serializer, this.ingredient, this.result, this.elementType, this.elementAmount));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final Item output;
        private final ElementType elementType;
        private final int elementAmount;
        private final IRecipeSerializer<?> serializer;

        public Result(ResourceLocation idIn, IRecipeSerializer<?> serializerIn, Ingredient ingredientIn, Item resultIn, ElementType elementType, int elementAmount) {
            this.id = idIn;
            this.serializer = serializerIn;
            this.ingredient = ingredientIn;
            this.output = resultIn;
            this.elementType = elementType;
            this.elementAmount = elementAmount;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("element_type", this.elementType.func_176610_l());
            json.addProperty("element_amount", (Number)this.elementAmount);
            json.add("input", this.ingredient.func_200304_c());
            json.addProperty("output", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.output).toString());
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

