/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.datagen.recipe.builder.instrument;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.recipe.instrument.InscriptionRecipe;

public class InscriptionRecipeBuilder {
    private final ResourceLocation output;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final ElementType elementType;
    private int elementAmount;
    private final IRecipeSerializer<?> serializer;
    private Ingredient slate;

    public InscriptionRecipeBuilder(IRecipeSerializer<?> serializerIn, ResourceLocation output, ElementType elementType) {
        this.serializer = serializerIn;
        this.elementType = elementType;
        this.elementAmount = 5000;
        this.output = output;
    }

    public static InscriptionRecipeBuilder inscriptionRecipe(ResourceLocation output, ElementType elementType) {
        return new InscriptionRecipeBuilder(InscriptionRecipe.SERIALIZER, output, elementType);
    }

    public InscriptionRecipeBuilder withElementAmount(int elementAmount) {
        this.elementAmount = elementAmount;
        return this;
    }

    public InscriptionRecipeBuilder setSlate(ITag.INamedTag<Item> tagIn) {
        return this.setSlate(Ingredient.func_199805_a(tagIn));
    }

    public InscriptionRecipeBuilder setSlate(IItemProvider itemIn) {
        return this.setSlate(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
    }

    public InscriptionRecipeBuilder setSlate(Ingredient ingredientIn) {
        this.slate = ingredientIn;
        return this;
    }

    public InscriptionRecipeBuilder addIngredient(ITag.INamedTag<Item> tagIn) {
        return this.addIngredient(Ingredient.func_199805_a(tagIn));
    }

    public InscriptionRecipeBuilder addIngredient(IItemProvider itemIn) {
        return this.addIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
    }

    public InscriptionRecipeBuilder addIngredient(Ingredient ingredientIn) {
        this.ingredients.add(ingredientIn);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, this.output.func_110623_a());
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        this.build(consumerIn, ElementalCraft.createRL("inscription/" + save));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.serializer, this.slate, this.ingredients, this.output, this.elementType, this.elementAmount));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient slate;
        private final List<Ingredient> ingredients;
        private final ResourceLocation output;
        private final ElementType elementType;
        private final int elementAmount;
        private final IRecipeSerializer<?> serializer;

        public Result(ResourceLocation idIn, IRecipeSerializer<?> serializerIn, Ingredient slate, List<Ingredient> ingredients, ResourceLocation output, ElementType elementType, int elementAmount) {
            this.id = idIn;
            this.serializer = serializerIn;
            this.slate = slate;
            this.ingredients = ingredients;
            this.output = output;
            this.elementType = elementType;
            this.elementAmount = elementAmount;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("element_type", this.elementType.func_176610_l());
            json.addProperty("element_amount", (Number)this.elementAmount);
            json.add("slate", this.slate.func_200304_c());
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.func_200304_c());
            }
            json.add("ingredients", (JsonElement)jsonarray);
            json.addProperty("output", this.output.toString());
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

