/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.entity;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.infusion.InfusionHelper;
import sirttas.elementalcraft.item.ECItems;

@Mod.EventBusSubscriber(modid="elementalcraft")
public class EntityHandler {
    @SubscribeEvent
    public static void onEntityUseItemTick(LivingEntityUseItemEvent.Tick event) {
        if (InfusionHelper.hasAirInfusionFasterDraw(event.getItem()) && event.getDuration() % 3 == 0) {
            event.setDuration(event.getDuration() - 1);
        }
    }

    @SubscribeEvent
    public static void onEntityLivingAttack(LivingAttackEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (!world.field_72995_K && InfusionHelper.hasInfusion(entity, EquipmentSlotType.CHEST, ElementType.AIR) && world.func_201674_k().nextDouble() <= (Double)ECConfig.COMMON.chestplateAirInfusionDodgeChance.get()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        CompoundNBT tag;
        PlayerEntity player = event.getPlayer();
        if (Boolean.TRUE.equals(ECConfig.COMMON.playersSpawnWithBook.get()) && !event.getEntityLiving().func_130014_f_().field_72995_K && !(tag = player.getPersistentData().func_74775_l("PlayerPersisted")).func_74767_n("has_elementopedia")) {
            ItemStack book = new ItemStack((IItemProvider)ECItems.elementopedia);
            book.func_196082_o().func_74778_a("patchouli:book", "elementalcraft:element_book");
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)book);
            tag.func_74757_a("has_elementopedia", true);
            player.getPersistentData().func_218657_a("PlayerPersisted", (INBT)tag);
        }
    }
}

