/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.gui.GuiHelper;
import sirttas.elementalcraft.item.holder.ItemElementHolder;
import sirttas.elementalcraft.item.spell.ISpellHolder;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.Spells;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft")
public class GuiHandler {
    @SubscribeEvent
    public static void onDrawScreenPost(RenderGameOverlayEvent.Post event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        RayTraceResult result = minecraft.field_71476_x;
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            ItemStack stack;
            if (result != null && minecraft.field_71474_y.func_243230_g().func_243192_a()) {
                Optional opt;
                TileEntity tile;
                BlockPos pos = result.func_216346_c() == RayTraceResult.Type.BLOCK ? ((BlockRayTraceResult)result).func_216350_a() : null;
                TileEntity tileEntity = tile = pos != null ? minecraft.field_71439_g.field_70170_p.func_175625_s(pos) : null;
                if (tile != null && (opt = CapabilityElementStorage.get(tile).filter(storage -> storage.doesRenderGauge() || GuiHelper.showDebugInfo())).isPresent()) {
                    IElementStorage storage2 = (IElementStorage)opt.get();
                    GuiHandler.doRenderElementGauge(event.getMatrixStack(), storage2.getElementAmount(), storage2.getElementCapacity(), storage2.getElementType());
                    return;
                }
            }
            if (!(stack = GuiHandler.getElementHolder()).func_190926_b() && stack.func_77973_b() instanceof ItemElementHolder) {
                ItemElementHolder holder = (ItemElementHolder)stack.func_77973_b();
                int amount = holder.getElementAmount(stack);
                Spell spell = GuiHandler.getSpell();
                GuiHandler.doRenderElementGauge(event.getMatrixStack(), amount, holder.getElementCapacity(), holder.getElementType());
                if (spell.isValid()) {
                    GuiHandler.doRenderCanCast(event.getMatrixStack(), amount >= spell.getConsumeAmount());
                }
            }
        }
    }

    private static ItemStack getElementHolder() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        return EntityHelper.handStream((PlayerEntity)player).map(stack -> {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemElementHolder) {
                return stack;
            }
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ISpellHolder) {
                return ItemElementHolder.find((PlayerEntity)player, SpellHelper.getSpell(stack).getElementType());
            }
            return ItemStack.field_190927_a;
        }).filter(s -> !s.func_190926_b()).findFirst().orElse(ItemStack.field_190927_a);
    }

    private static Spell getSpell() {
        return EntityHelper.handStream((PlayerEntity)Minecraft.func_71410_x().field_71439_g).map(stack -> {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ISpellHolder) {
                return SpellHelper.getSpell(stack);
            }
            return Spells.none;
        }).filter(Spell::isValid).findFirst().orElse(Spells.none);
    }

    private static void doRenderElementGauge(MatrixStack matrixStack, int element, int max, ElementType type) {
        GuiHelper.renderElementGauge(matrixStack, GuiHandler.getXoffset() - 32, GuiHandler.getYOffset() - 8, element, max, type);
    }

    public static int getYOffset() {
        return Minecraft.func_71410_x().func_228018_at_().func_198087_p() / 2 + (Integer)ECConfig.CLIENT.gaugeOffsetX.get();
    }

    public static int getXoffset() {
        return Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 + (Integer)ECConfig.CLIENT.gaugeOffsetY.get();
    }

    private static void doRenderCanCast(MatrixStack matrixStack, boolean canCast) {
        GuiHelper.renderCanCast(matrixStack, GuiHandler.getXoffset() - 21, GuiHandler.getYOffset() + 3, canCast);
    }
}

