/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.config.ECConfig;

public class GuiHelper {
    @OnlyIn(value=Dist.CLIENT)
    private static final ResourceLocation GAUGE = ElementalCraft.createRL("textures/gui/element_gauge.png");

    @OnlyIn(value=Dist.CLIENT)
    public static void blit(MatrixStack matrixStack, int x, int y, int u, int v, int width, int height) {
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)256, (int)256);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int getElementTypeOffset(ElementType type) {
        switch (type) {
            case WATER: {
                return 1;
            }
            case FIRE: {
                return 2;
            }
            case EARTH: {
                return 3;
            }
            case AIR: {
                return 4;
            }
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderElementGauge(MatrixStack matrixStack, int x, int y, int amount, int max, ElementType type) {
        GuiHelper.renderElementGauge(matrixStack, x, y, amount, max, type, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderElementGauge(MatrixStack matrixStack, int x, int y, int amount, int max, ElementType type, boolean showDebugInfo) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(GAUGE);
        GuiHelper.blit(matrixStack, x, y, 0, 0, 16, 16);
        int progress = Math.max(0, (int)((double)Math.min(amount, max) / (double)max * 16.0));
        if (progress <= 1 && amount > 0) {
            progress = 2;
        }
        GuiHelper.blit(matrixStack, x, y + 16 - progress, GuiHelper.getElementTypeOffset(type) * 16, 16 - progress + (Boolean.TRUE.equals(ECConfig.CLIENT.usePaleElementGauge.get()) ? 16 : 0), 16, progress);
        if (GuiHelper.showDebugInfo() && showDebugInfo) {
            mc.field_71466_p.func_238405_a_(matrixStack, amount + "/" + max, (float)x, (float)(y + 16), 0xFFFFFF);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderCanCast(MatrixStack matrixStack, int x, int y, boolean canCast) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GAUGE);
        GuiHelper.blit(matrixStack, x, y, canCast ? 0 : 6, 16, 6, 6);
    }

    public static boolean showDebugInfo() {
        Minecraft minecraft = Minecraft.func_71410_x();
        return minecraft.field_71439_g.func_184812_l_() && minecraft.field_71474_y.field_82882_x;
    }
}

