/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.infusion.InfusionHelper;
import sirttas.elementalcraft.interaction.jei.category.PureInfusionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.EvaporationRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.ExtractionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.ImprovedExtractionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.BindingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.CrystallizationRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.InscriptionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.PurificationRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.infusion.InfusionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.infusion.ToolInfusionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.interaction.jei.ingredient.element.ElementIngredientHelper;
import sirttas.elementalcraft.interaction.jei.ingredient.element.ElementIngredientRenderer;
import sirttas.elementalcraft.interaction.jei.ingredient.element.IngredientElementType;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.recipe.PureInfusionRecipe;
import sirttas.elementalcraft.recipe.instrument.BindingRecipe;
import sirttas.elementalcraft.recipe.instrument.CrystallizationRecipe;
import sirttas.elementalcraft.recipe.instrument.InscriptionRecipe;
import sirttas.elementalcraft.recipe.instrument.infusion.AbstractInfusionRecipe;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;

@JeiPlugin
public class ElementalCraftJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ElementalCraft.createRL("main");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(ECIngredientTypes.ELEMENT, IngredientElementType.all(), (IIngredientHelper)new ElementIngredientHelper(), (IIngredientRenderer)new ElementIngredientRenderer());
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        registry.useNbtForSubtypes(new Item[]{ECItems.scroll});
        registry.useNbtForSubtypes(new Item[]{ECItems.receptacle});
        registry.useNbtForSubtypes(new Item[]{ECItems.pureOre});
        registry.useNbtForSubtypes(new Item[]{ECItems.airElementHolder});
        registry.useNbtForSubtypes(new Item[]{ECItems.earthElementHolder});
        registry.useNbtForSubtypes(new Item[]{ECItems.fireElementHolder});
        registry.useNbtForSubtypes(new Item[]{ECItems.waterElementHolder});
        registry.useNbtForSubtypes(new Item[]{ECItems.rune});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new ExtractionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ImprovedExtractionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new EvaporationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new InfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ToolInfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new BindingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrystallizationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new InscriptionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PureInfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PurificationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.fireFurnace), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.fireBlastFurnace), new ResourceLocation[]{VanillaRecipeCategoryUid.BLASTING});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.extractor), new ResourceLocation[]{ExtractionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.improvedExtractor), new ResourceLocation[]{ImprovedExtractionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.evaporator), new ResourceLocation[]{EvaporationRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.infuser), new ResourceLocation[]{InfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.infuser), new ResourceLocation[]{ToolInfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.binder), new ResourceLocation[]{BindingRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.crystallizer), new ResourceLocation[]{CrystallizationRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.inscriber), new ResourceLocation[]{InscriptionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.chisel), new ResourceLocation[]{InscriptionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.pureInfuser), new ResourceLocation[]{PureInfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.firePedestal), new ResourceLocation[]{PureInfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.waterPedestal), new ResourceLocation[]{PureInfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.earthPedestal), new ResourceLocation[]{PureInfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.airPedestal), new ResourceLocation[]{PureInfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.purifier), new ResourceLocation[]{PurificationRecipeCategory.UID});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        registry.addRecipes(ElementType.allValid(), ExtractionRecipeCategory.UID);
        registry.addRecipes(ElementType.allValid(), ImprovedExtractionRecipeCategory.UID);
        registry.addRecipes(EvaporationRecipeCategory.getShards(), EvaporationRecipeCategory.UID);
        registry.addRecipes(recipeManager.func_215366_a(AbstractInfusionRecipe.TYPE).values(), InfusionRecipeCategory.UID);
        registry.addRecipes(InfusionHelper.getRecipes(), ToolInfusionRecipeCategory.UID);
        registry.addRecipes(recipeManager.func_215366_a(BindingRecipe.TYPE).values(), BindingRecipeCategory.UID);
        registry.addRecipes(recipeManager.func_215366_a(CrystallizationRecipe.TYPE).values(), CrystallizationRecipeCategory.UID);
        registry.addRecipes(recipeManager.func_215366_a(InscriptionRecipe.TYPE).values(), InscriptionRecipeCategory.UID);
        registry.addRecipes(recipeManager.func_215366_a(PureInfusionRecipe.TYPE).values(), PureInfusionRecipeCategory.UID);
        registry.addRecipes(ElementalCraft.PURE_ORE_MANAGER.getRecipes(), PurificationRecipeCategory.UID);
        registry.addRecipes(this.createFocusAnvilRecipes(registry.getVanillaRecipeFactory()), VanillaRecipeCategoryUid.ANVIL);
    }

    private List<?> createFocusAnvilRecipes(IVanillaRecipeFactory factory) {
        return Spell.REGISTRY.getValues().stream().filter(Spell::isValid).map(spell -> {
            ItemStack scroll = new ItemStack((IItemProvider)ECItems.scroll);
            ItemStack focus = new ItemStack((IItemProvider)ECItems.focus);
            SpellHelper.setSpell(scroll, spell);
            SpellHelper.addSpell(focus, spell);
            return factory.createAnvilRecipe(new ItemStack((IItemProvider)ECItems.focus), (List)ImmutableList.of((Object)scroll), (List)ImmutableList.of((Object)focus));
        }).collect(Collectors.toList());
    }
}

