/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category.element;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.interaction.jei.ingredient.element.IngredientElementType;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.ItemElemental;
import sirttas.elementalcraft.tag.ECTags;

public class EvaporationRecipeCategory
implements IRecipeCategory<Ingredient> {
    public static final ResourceLocation UID = ElementalCraft.createRL("evaporation");
    private final IDrawable icon;
    private final IDrawable background;
    private final IDrawable overlay;
    private final ItemStack evaporator = new ItemStack((IItemProvider)ECItems.evaporator);
    protected final List<ItemStack> tanks = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)ECItems.tank), new ItemStack((IItemProvider)ECItems.tankSmall)});

    public EvaporationRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(99, 59);
        this.icon = guiHelper.createDrawableIngredient((Object)this.evaporator);
        this.overlay = guiHelper.createDrawable(ElementalCraft.createRL("textures/gui/evaporation_overlay.png"), 0, 0, 64, 29);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends Ingredient> getRecipeClass() {
        return Ingredient.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"elementalcraft.jei.evaporation", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public List<ITextComponent> getTooltipStrings(Ingredient recipe, double mouseX, double mouseY) {
        if (mouseX > 0.0 && mouseX < 16.0 && mouseY > 0.0 && mouseY < 16.0) {
            return Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("block.elementalcraft.source." + this.getElementType(recipe).func_176610_l())});
        }
        return Collections.emptyList();
    }

    public void draw(Ingredient recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(matrixStack, 8, 20);
        RenderSystem.disableBlend();
    }

    public void setIngredients(Ingredient recipe, IIngredients ingredients) {
        ArrayList inputs = new ArrayList();
        inputs.add(Stream.of(recipe.func_193365_a()).collect(Collectors.toList()));
        ingredients.setInputLists(VanillaTypes.ITEM, inputs);
        ingredients.setOutput(ECIngredientTypes.ELEMENT, (Object)new IngredientElementType(this.getElementType(recipe), 1));
    }

    private ElementType getElementType(Ingredient recipe) {
        Item item;
        ItemStack[] stacks = recipe.func_193365_a();
        if (stacks != null && stacks.length > 0 && (item = stacks[0].func_77973_b()) instanceof ItemElemental) {
            return ((ItemElemental)item).getElementType();
        }
        return ElementType.NONE;
    }

    public void setRecipe(IRecipeLayout recipeLayout, Ingredient recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 0, 0);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(1, false, 30, 40);
        recipeLayout.getItemStacks().set(1, this.tanks);
        recipeLayout.getItemStacks().init(2, false, 30, 24);
        recipeLayout.getItemStacks().set(2, this.evaporator);
        recipeLayout.getIngredientsGroup(ECIngredientTypes.ELEMENT).init(2, true, 75, 40);
        recipeLayout.getIngredientsGroup(ECIngredientTypes.ELEMENT).set(2, (List)ingredients.getOutputs(ECIngredientTypes.ELEMENT).get(0));
    }

    public static List<Ingredient> getShards() {
        try {
            return Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199805_a(ECTags.Items.FIRE_SHARDS), Ingredient.func_199805_a(ECTags.Items.WATER_SHARDS), Ingredient.func_199805_a(ECTags.Items.EARTH_SHARDS), Ingredient.func_199805_a(ECTags.Items.AIR_SHARDS)});
        }
        catch (Exception e) {
            return Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ECItems.fireShard}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ECItems.waterShard}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ECItems.earthShard}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ECItems.airShard})});
        }
    }
}

