/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category.instrument;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.instrument.crystallizer.TileCrystallizer;
import sirttas.elementalcraft.interaction.jei.category.instrument.AbstractInstrumentRecipeCategory;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.recipe.instrument.CrystallizationRecipe;

public class CrystallizationRecipeCategory
extends AbstractInstrumentRecipeCategory<TileCrystallizer, CrystallizationRecipe> {
    public static final ResourceLocation UID = ElementalCraft.createRL("crystallization");
    private final IDrawable icon;
    private final IDrawable background;
    private ItemStack crystallizer = new ItemStack((IItemProvider)ECItems.crystallizer);

    public CrystallizationRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(132, 110);
        this.icon = guiHelper.createDrawableIngredient((Object)this.crystallizer);
        this.setOverlay((IDrawable)guiHelper.createDrawable(ElementalCraft.createRL("textures/gui/crystallization_overlay.png"), 0, 0, 124, 52), 10, 10);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends CrystallizationRecipe> getRecipeClass() {
        return CrystallizationRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"elementalcraft.jei.crystallization", (Object[])new Object[0]);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void setIngredients(CrystallizationRecipe recipe, IIngredients ingredients) {
        ArrayList outputs = new ArrayList();
        outputs.add(recipe.getOutputs().keySet().stream().collect(Collectors.toList()));
        super.setIngredients(recipe, ingredients);
        ingredients.setOutputLists(VanillaTypes.ITEM, outputs);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CrystallizationRecipe recipe, IIngredients ingredients) {
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        recipeLayout.getItemStacks().addTooltipCallback((slot, input, ingredient, tooltip) -> {
            if (slot == 6) {
                tooltip.add(new TranslationTextComponent("tooltip.elementalcraft.chance", new Object[]{ItemStack.field_111284_a.format(recipe.getOutputs().get(ingredient) * 100 / recipe.getTotalWeight())}));
            }
        });
        recipeLayout.getItemStacks().init(0, true, 42, 32);
        recipeLayout.getItemStacks().set(0, (List)inputs.get(0));
        recipeLayout.getItemStacks().init(1, true, 42, 14);
        recipeLayout.getItemStacks().set(1, (List)inputs.get(1));
        recipeLayout.getItemStacks().init(2, true, 6, 21);
        recipeLayout.getItemStacks().set(2, (List)inputs.get(2));
        recipeLayout.getItemStacks().init(3, false, 42, 68);
        recipeLayout.getItemStacks().set(3, this.tank);
        recipeLayout.getItemStacks().init(4, false, 42, 52);
        recipeLayout.getItemStacks().set(4, this.crystallizer);
        recipeLayout.getIngredientsGroup(ECIngredientTypes.ELEMENT).init(5, true, 43, 86);
        recipeLayout.getIngredientsGroup(ECIngredientTypes.ELEMENT).set(5, (List)ingredients.getInputs(ECIngredientTypes.ELEMENT).get(0));
        recipeLayout.getItemStacks().init(6, false, 116, 42);
        recipeLayout.getItemStacks().set(6, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

