/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category.instrument;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.instrument.purifier.TilePurifier;
import sirttas.elementalcraft.interaction.jei.category.instrument.AbstractInstrumentRecipeCategory;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.recipe.instrument.PurifierRecipe;

public class PurificationRecipeCategory
extends AbstractInstrumentRecipeCategory<TilePurifier, PurifierRecipe> {
    public static final ResourceLocation UID = ElementalCraft.createRL("purification");
    private final IDrawable icon;
    private final IDrawable background;
    private ItemStack purifier = new ItemStack((IItemProvider)ECItems.purifier);

    public PurificationRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(75, 75);
        this.icon = guiHelper.createDrawableIngredient((Object)this.purifier);
        this.setOverlay((IDrawable)guiHelper.createDrawable(ElementalCraft.createRL("textures/gui/infusion_overlay.png"), 0, 0, 65, 16), 8, 20);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends PurifierRecipe> getRecipeClass() {
        return PurifierRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"elementalcraft.jei.purification", (Object[])new Object[0]);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, PurifierRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 0, 0);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(1, false, 30, 40);
        recipeLayout.getItemStacks().set(1, this.tank);
        recipeLayout.getItemStacks().init(2, false, 30, 24);
        recipeLayout.getItemStacks().set(2, this.purifier);
        recipeLayout.getIngredientsGroup(ECIngredientTypes.ELEMENT).init(3, true, 31, 58);
        recipeLayout.getIngredientsGroup(ECIngredientTypes.ELEMENT).set(3, (List)ingredients.getInputs(ECIngredientTypes.ELEMENT).get(0));
        recipeLayout.getItemStacks().init(4, false, 59, 0);
        recipeLayout.getItemStacks().set(4, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

