/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.holder;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.math.NumberUtils;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.source.ISourceInteractable;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.ItemElemental;
import sirttas.elementalcraft.property.ECProperties;

public class ItemElementHolder
extends ItemElemental
implements ISourceInteractable {
    public static final String NAME = "element_holder";
    public static final String NAME_FIRE = "element_holder_fire";
    public static final String NAME_WATER = "element_holder_water";
    public static final String NAME_EARTH = "element_holder_earth";
    public static final String NAME_AIR = "element_holder_air";
    private static final String SAVED_POS = "saved_pos";
    private final int elementCapacity;

    public ItemElementHolder(ElementType elementType) {
        super(ECProperties.Items.ITEM_UNSTACKABLE, elementType);
        this.elementCapacity = (Integer)ECConfig.COMMON.elementHolderCapacity.get();
    }

    public int getElementCapacity() {
        return this.elementCapacity;
    }

    public int func_77626_a(ItemStack stack) {
        return (Integer)ECConfig.COMMON.elementHolderCapacity.get() / (Integer)ECConfig.COMMON.elementHolderTransferAmount.get();
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    protected boolean isValidSource(BlockState state) {
        return state.func_177230_c().equals(ECBlocks.source) && state.func_177229_b(ECProperties.ELEMENT_TYPE) == this.elementType;
    }

    @Override
    public boolean canIteractWithSource(ItemStack stack, BlockState state) {
        return this.isValidSource(state);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        ItemStack stack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        ActionResultType result = this.tick(world, (LivingEntity)player, pos, stack);
        if (result.func_226246_a_()) {
            this.setSavedPos(stack, pos);
            player.func_184598_c(context.func_221531_n());
        }
        return result;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (!this.tick(player.func_130014_f_(), player, this.getSavedPos(stack), stack).func_226246_a_()) {
            player.func_184597_cx();
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        this.removeSavedPos(stack);
    }

    private ActionResultType tick(World world, LivingEntity entity, BlockPos pos, ItemStack stack) {
        int amount;
        BlockState blockstate = world.func_180495_p(pos);
        IElementStorage storage = CapabilityElementStorage.getElementStorageAt((IWorldReader)world, pos);
        if (this.isValidSource(blockstate)) {
            this.inserElement(stack, (Integer)ECConfig.COMMON.elementHolderTransferAmount.get());
            return ActionResultType.CONSUME;
        }
        if (entity.func_225608_bj_()) {
            int amount2;
            if (storage.canPipeExtract() && storage.getElementType() == this.elementType && (amount2 = NumberUtils.min((int)storage.getElementAmount(), (int)((Integer)ECConfig.COMMON.elementHolderTransferAmount.get()), (int)(this.getElementCapacity() - this.getElementAmount(stack)))) > 0) {
                storage.extractElement(amount2, this.elementType, false);
                this.inserElement(stack, amount2);
                return ActionResultType.CONSUME;
            }
        } else if ((storage.canPipeInsert() && storage.getElementType() == this.elementType || storage.getElementType() == null) && (amount = NumberUtils.min((int)this.getElementAmount(stack), (int)((Integer)ECConfig.COMMON.elementHolderTransferAmount.get()), (int)(storage.getElementCapacity() - storage.getElementAmount()))) > 0) {
            this.extractElement(stack, amount);
            storage.insertElement(amount, this.elementType, false);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.elementalcraft.percent_full", new Object[]{ItemStack.field_111284_a.format(this.getElementAmount(stack) * 100 / this.elementCapacity)}).func_240699_a_(TextFormatting.GREEN));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack full = new ItemStack((IItemProvider)this);
            this.setElementAmount(full, this.elementCapacity);
            items.add((Object)new ItemStack((IItemProvider)this));
            items.add((Object)full);
        }
    }

    public int getDamage(ItemStack stack) {
        return 1000 * (this.elementCapacity - this.getElementAmount(stack)) / this.elementCapacity;
    }

    public int getMaxDamage(ItemStack stack) {
        return 1000;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public int getElementAmount(ItemStack stack) {
        return stack.func_77978_p() == null ? 0 : stack.func_77978_p().func_74762_e("element_amount");
    }

    public void setElementAmount(ItemStack stack, int amount) {
        stack.func_196082_o().func_74768_a("element_amount", Math.min(amount, this.elementCapacity));
    }

    public BlockPos getSavedPos(ItemStack stack) {
        CompoundNBT savedPos;
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && (savedPos = tag.func_74775_l(SAVED_POS)) != null) {
            return new BlockPos(savedPos.func_74762_e("x"), savedPos.func_74762_e("y"), savedPos.func_74762_e("z"));
        }
        return null;
    }

    public void setSavedPos(ItemStack stack, BlockPos pos) {
        CompoundNBT savedPos = new CompoundNBT();
        savedPos.func_74768_a("x", pos.func_177958_n());
        savedPos.func_74768_a("y", pos.func_177956_o());
        savedPos.func_74768_a("z", pos.func_177952_p());
        stack.func_196082_o().func_218657_a(SAVED_POS, (INBT)savedPos);
    }

    public void removeSavedPos(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            tag.func_82580_o(SAVED_POS);
        }
    }

    public int inserElement(ItemStack stack, int amount) {
        int elementAmount = this.getElementAmount(stack);
        int newCount = Math.min(elementAmount + amount, this.elementCapacity);
        int ret = amount - newCount + elementAmount;
        this.setElementAmount(stack, newCount);
        return ret;
    }

    public int extractElement(ItemStack stack, int amount) {
        int elementAmount = this.getElementAmount(stack);
        int newCount = Math.max(elementAmount - amount, 0);
        int ret = elementAmount - newCount;
        this.setElementAmount(stack, newCount);
        return ret;
    }

    public static ItemStack find(PlayerEntity player, ElementType elementType) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemElementHolder) || ((ItemElementHolder)item).getElementType() != elementType) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }
}

